/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.cxbox.api.service.LocaleService;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.core.config.ControllerScan;
import org.cxbox.core.config.EnhancedLocaleResolver;
import org.cxbox.core.config.properties.APIProperties;
import org.cxbox.core.controller.param.resolvers.LocaleParameterArgumentResolver;
import org.cxbox.core.controller.param.resolvers.PageParameterArgumentResolver;
import org.cxbox.core.controller.param.resolvers.QueryParametersResolver;
import org.cxbox.core.controller.param.resolvers.TimeZoneParameterArgumentResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableWebMvc
@ControllerScan(value={"org.cxbox.core.controller"})
@EnableConfigurationProperties(value={APIProperties.class})
public class APIConfig
implements WebMvcConfigurer {
    @Qualifier(value="cxboxObjectMapper")
    protected final ObjectMapper objectMapper;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new PageParameterArgumentResolver());
        argumentResolvers.add(new QueryParametersResolver());
        argumentResolvers.add(new TimeZoneParameterArgumentResolver());
        argumentResolvers.add(new LocaleParameterArgumentResolver());
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper));
    }

    @Bean
    @ConditionalOnProperty(value={"cxbox.bean.multipart-resolver.enabled"}, matchIfMissing=true)
    public MultipartResolver multipartResolver() {
        StandardServletMultipartResolver resolver = new StandardServletMultipartResolver();
        return resolver;
    }

    @Bean(name={"localeResolver"})
    public LocaleResolver localeResolver(CoreSessionService coreSessionService, LocaleService localeService) {
        return new EnhancedLocaleResolver(coreSessionService, localeService);
    }

    @ConstructorProperties(value={"objectMapper"})
    @Generated
    public APIConfig(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

