/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDateTime;
import java.util.Date;
import org.cxbox.api.util.jackson.DtoPropertyFilter;
import org.cxbox.api.util.jackson.deser.contextual.TZAwareLDTContextualDeserializer;
import org.cxbox.api.util.jackson.ser.contextual.I18NAwareStringContextualSerializer;
import org.cxbox.api.util.jackson.ser.contextual.TZAwareJUDContextualSerializer;
import org.cxbox.api.util.jackson.ser.contextual.TZAwareLDTContextualSerializer;
import org.cxbox.core.config.properties.WidgetFieldsIdResolverProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.SpringHandlerInstantiator;

@Configuration
@EnableConfigurationProperties(value={WidgetFieldsIdResolverProperties.class})
public class JacksonConfig {
    @Bean(value={"cxboxObjectMapper"})
    public ObjectMapper cxboxObjectMapper(HandlerInstantiator handlerInstantiator) {
        return Jackson2ObjectMapperBuilder.json().handlerInstantiator(handlerInstantiator).modules(new Module[]{this.buildJavaTimeModule(), this.i18NModule()}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, SerializationFeature.FLUSH_AFTER_WRITE_VALUE, JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM}).filters((FilterProvider)new SimpleFilterProvider().addFilter("dtoPropertyFilter", (SimpleBeanPropertyFilter)new DtoPropertyFilter())).build();
    }

    @Bean
    public HandlerInstantiator handlerInstantiator(ApplicationContext context) {
        return new SpringHandlerInstantiator(context.getAutowireCapableBeanFactory());
    }

    private JavaTimeModule buildJavaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new TZAwareLDTContextualDeserializer());
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new TZAwareLDTContextualSerializer());
        javaTimeModule.addSerializer(Date.class, (JsonSerializer)new TZAwareJUDContextualSerializer());
        return javaTimeModule;
    }

    private SimpleModule i18NModule() {
        SimpleModule i18NModule = new SimpleModule();
        i18NModule.addSerializer(String.class, (JsonSerializer)new I18NAwareStringContextualSerializer());
        return i18NModule;
    }
}

