/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dto.RedirectDTO;
import org.cxbox.api.system.SystemSettings;
import org.cxbox.core.controller.http.AJAXRedirectStrategy;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

@Component
public class AJAXRedirectStrategyImpl
extends DefaultRedirectStrategy
implements AJAXRedirectStrategy {
    public static final String UI_HASH = "#/";
    public static final String SLASH = "/";
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;
    private final RequestMatcher ajaxRequestMatcher;

    public AJAXRedirectStrategyImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.ajaxRequestMatcher = this.createAJAXRequestMatcher();
    }

    @Override
    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        String redirectUrl = this.calculateRedirectUrl(request, url);
        if (!this.isAjaxRequest(request)) {
            this.doSendRedirect(request, response, redirectUrl);
        }
        RedirectDTO redirect = new RedirectDTO(response.encodeRedirectURL(redirectUrl));
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        this.objectMapper.writeValue((Writer)response.getWriter(), (Object)redirect);
    }

    protected void doSendRedirect(HttpServletRequest request, HttpServletResponse response, String url) {
        response.setHeader("Location", response.encodeRedirectURL(url));
        response.sendError(HttpStatus.FOUND.value());
    }

    @Override
    public String calculateRedirectUrl(HttpServletRequest request, String url) {
        if (UrlUtils.isValidRedirectUrl((String)url)) {
            return url;
        }
        Object uiLocation = this.getUILocation(request);
        if (uiLocation == null) {
            uiLocation = request.getContextPath();
        }
        if (!((String)uiLocation).endsWith(SLASH)) {
            uiLocation = (String)uiLocation + SLASH;
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            return uiLocation;
        }
        return (String)uiLocation + url;
    }

    @Override
    public boolean isAjaxRequest(HttpServletRequest request) {
        return this.ajaxRequestMatcher.matches(request);
    }

    @Override
    public String getReferrer(HttpServletRequest request) {
        return request.getHeader("Referer");
    }

    @Override
    public String getUILocation(HttpServletRequest request) {
        if (!this.isAjaxRequest(request)) {
            return this.getSystemUrl();
        }
        String referrer = this.getReferrer(request);
        if (StringUtils.isBlank((CharSequence)referrer)) {
            return this.getSystemUrl();
        }
        return this.addUiHash(referrer);
    }

    @Override
    public String getSystemUrl() {
        return this.addUiHash(SystemSettings.systemSettings().getValue(CoreDictionaries.SystemPref.SYSTEM_URL));
    }

    private String addUiHash(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        if (!url.endsWith(UI_HASH)) {
            return url + UI_HASH;
        }
        return url;
    }

    private RequestMatcher createAJAXRequestMatcher() {
        MediaTypeRequestMatcher jsonRequest = new MediaTypeRequestMatcher((ContentNegotiationStrategy)new HeaderContentNegotiationStrategy(), new MediaType[]{MediaType.APPLICATION_JSON});
        jsonRequest.setUseEquals(true);
        jsonRequest.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        RequestHeaderRequestMatcher xmlHttpRequest = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");
        RequestHeaderRequestMatcher clientIdRequest = new RequestHeaderRequestMatcher("ClientId", null);
        return new OrRequestMatcher(new RequestMatcher[]{jsonRequest, clientIdRequest, xmlHttpRequest});
    }
}

