/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.AssociateDTO;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.PreviewResult;
import org.cxbox.api.util.Invoker;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.Crudma;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.CrudmaFactory;
import org.cxbox.core.crudma.InterimResult;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.crudma.ext.CrudmaGatewayInvokeExtensionProvider;
import org.cxbox.core.dto.BusinessError;
import org.cxbox.core.dto.MessageType;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.AssociateResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.exception.BusinessIntermediateException;
import org.cxbox.core.service.ResponseFactory;
import org.cxbox.core.service.ResponseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CrudmaGateway {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrudmaGateway.class);
    private final CrudmaFactory crudmaFactory;
    private final ResponseFactory respFactory;
    private final List<CrudmaGatewayInvokeExtensionProvider> extensionProviders;

    public DataResponseDTO get(CrudmaActionHolder.CrudmaAction crudmaAction) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        return (DataResponseDTO)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).get(bc), readOnly);
    }

    public ResultPage<? extends DataResponseDTO> getAll(CrudmaActionHolder.CrudmaAction crudmaAction) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        return (ResultPage)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).getAll(bc), readOnly);
    }

    public MetaDTO create(CrudmaActionHolder.CrudmaAction crudmaAction) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        InterimResult result = (InterimResult)this.invoke(crudmaAction, () -> {
            Crudma crudmaService = this.getCrudmaService(bc);
            CreateResult createResult = crudmaService.create(bc);
            if (readOnly) {
                createResult.getRecord().setVstamp(-1L);
            }
            MetaDTO metaNew = crudmaService.getMetaNew(bc, createResult);
            return new InterimResult(bc, (DataResponseDTO)createResult.getRecord(), metaNew);
        }, readOnly);
        return result.getMeta();
    }

    public MetaDTO preview(CrudmaActionHolder.CrudmaAction crudmaAction, Map<String, Object> data) {
        boolean readOnly;
        BusinessComponent bc = crudmaAction.getBc();
        InterimResult result = (InterimResult)this.invoke(crudmaAction, () -> this.lambda$preview$3(bc, data, readOnly = this.isReadOnly(crudmaAction)), readOnly);
        if (result.getDto().getErrors() == null) {
            return result.getMeta();
        }
        throw new BusinessIntermediateException().setObject(result.getMeta()).setEntity((BusinessError.Entity)result.getDto().getErrors());
    }

    public ActionResultDTO update(CrudmaActionHolder.CrudmaAction crudmaAction, Map<String, Object> data) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        return (ActionResultDTO)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).update(bc, data), readOnly);
    }

    public ActionResultDTO delete(CrudmaActionHolder.CrudmaAction crudmaAction) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        if (bc.getId() == null) {
            return new ActionResultDTO().setAction(PostAction.showMessage(MessageType.WARNING, ErrorMessageSource.errorMessage((String)"warn.no_record_to_delete")));
        }
        return (ActionResultDTO)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).delete(bc), readOnly);
    }

    public ActionResultDTO invokeAction(CrudmaActionHolder.CrudmaAction crudmaAction, Map<String, Object> data) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        String actionName = crudmaAction.getName();
        return (ActionResultDTO)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).invokeAction(bc, actionName, data), readOnly);
    }

    public AssociateResultDTO associate(CrudmaActionHolder.CrudmaAction crudmaAction, List<AssociateDTO> data) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        return (AssociateResultDTO)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).associate(bc, data), readOnly);
    }

    public MetaDTO getMeta(CrudmaActionHolder.CrudmaAction crudmaAction) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        MetaDTO meta = (MetaDTO)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).getMeta(bc), readOnly);
        return meta;
    }

    public MetaDTO getMetaEmpty(CrudmaActionHolder.CrudmaAction crudmaAction) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        return (MetaDTO)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).getMetaEmpty(bc), readOnly);
    }

    public long count(CrudmaActionHolder.CrudmaAction crudmaAction) {
        BusinessComponent bc = crudmaAction.getBc();
        boolean readOnly = this.isReadOnly(crudmaAction);
        return (Long)this.invoke(crudmaAction, () -> this.getCrudmaService(bc).count(bc), readOnly);
    }

    private <T> T invoke(CrudmaActionHolder.CrudmaAction crudmaAction, Invoker<T, RuntimeException> invoker, boolean readOnly) {
        Invoker<T, RuntimeException> extendableInvoker = invoker;
        for (CrudmaGatewayInvokeExtensionProvider extensionProvider : this.extensionProviders) {
            extendableInvoker = extensionProvider.extendInvoker(crudmaAction, extendableInvoker, readOnly);
        }
        return (T)extendableInvoker.invoke();
    }

    private boolean isReadOnly(CrudmaActionHolder.CrudmaAction action) {
        CrudmaActionType actionType = action.getActionType();
        BusinessComponent bc = action.getBc();
        Object description = bc.getDescription();
        boolean readOnly = false;
        if (description instanceof InnerBcDescription) {
            readOnly = actionType != null && actionType.isReadOnly();
            ResponseService<?, ?> responseService = this.getResponseService(bc);
            if (CrudmaActionType.CREATE == actionType) {
                readOnly &= responseService.isDeferredCreationSupported(bc);
            }
        }
        return readOnly;
    }

    private ResponseService<?, ?> getResponseService(BusinessComponent bc) {
        return this.respFactory.getService((InnerBcDescription)bc.getDescription());
    }

    private Crudma getCrudmaService(BusinessComponent bc) {
        return this.crudmaFactory.get((BcDescription)bc.getDescription());
    }

    @ConstructorProperties(value={"crudmaFactory", "respFactory", "extensionProviders"})
    @Generated
    public CrudmaGateway(CrudmaFactory crudmaFactory, ResponseFactory respFactory, List<CrudmaGatewayInvokeExtensionProvider> extensionProviders) {
        this.crudmaFactory = crudmaFactory;
        this.respFactory = respFactory;
        this.extensionProviders = extensionProviders;
    }

    private /* synthetic */ InterimResult lambda$preview$3(BusinessComponent bc, Map data, boolean readOnly) throws RuntimeException {
        Crudma crudmaService = this.getCrudmaService(bc);
        PreviewResult previewResult = crudmaService.preview(bc, data);
        if (readOnly) {
            previewResult.getResponseDto().setVstamp(previewResult.getRequestDto().getVstamp());
        }
        MetaDTO metaNew = crudmaService.getOnFieldUpdateMeta(bc, previewResult.getResponseDto());
        return new InterimResult(bc, previewResult.getRequestDto(), metaNew);
    }
}

