/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl.inner;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.cxbox.api.ExtendedDtoFieldLevelSecurityService;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.UniversalDTO;
import org.cxbox.api.data.dto.UniversalDTO_;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractCrudmaService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.EngineFieldsMeta;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.dto.rowmeta.RowMetaDTO;
import org.cxbox.core.service.ResponseFactory;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.rowmeta.RowMetaType;
import org.cxbox.core.util.ListPaging;
import org.cxbox.model.core.dao.JpaDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cglib.beans.BeanGenerator;

public abstract class UniversalCrudmaService<D extends UniversalDTO, E>
extends AbstractCrudmaService {
    @Autowired
    protected JpaDao jpaDao;
    @Autowired
    protected ResponseFactory responseFactory;
    @Autowired
    private Optional<ExtendedDtoFieldLevelSecurityService> extendedDtoFieldLevelSecurityService;
    @Autowired
    @Qualifier(value="cxboxObjectMapper")
    private ObjectMapper objectMapper;

    protected abstract Class<D> getDtoClass();

    protected abstract Class<? extends E> getEntityClass(BusinessComponent var1);

    protected D entityToDto(E entity, Class<? extends D> dtoClass, Set<String> attributes) {
        UniversalDTO dto = (UniversalDTO)dtoClass.newInstance();
        this.getValues(entity, attributes).forEach((arg_0, arg_1) -> ((UniversalDTO)dto).set(arg_0, arg_1));
        return (D)dto;
    }

    @Override
    public ActionResultDTO update(BusinessComponent bc, Map<String, Object> data) {
        List<Attribute<?, ?>> attributes = this.getAttributes(bc);
        E entity = this.getEntity(bc);
        Class<D> dtoClass = this.createDTOClass(attributes);
        UniversalDTO dto = (UniversalDTO)this.responseFactory.getDTOFromMap(data, dtoClass, bc);
        this.setAttributes(entity, dto, attributes);
        return new ActionResultDTO<D>(this.entityToDto(entity, dtoClass, this.extractNames(attributes)));
    }

    protected void setAttributes(E entity, D dto, List<Attribute<?, ?>> attributes) {
        Set<String> names = attributes.stream().filter(a -> dto.isFieldChanged(a.getName())).map(Attribute::getName).collect(Collectors.toSet());
        this.setValues(entity, (UniversalDTO)dto, names);
    }

    @Override
    public MetaDTO getMeta(BusinessComponent bc) {
        Object data;
        List<Attribute<?, ?>> attributes = this.getAttributes(bc);
        if (bc.getId() != null) {
            data = this.get(bc);
        } else {
            Class<D> dtoClass = this.createDTOClass(attributes);
            data = (UniversalDTO)dtoClass.newInstance();
        }
        EngineFieldsMeta meta = this.getMeta((BcIdentifier)bc.getDescription(), RowMetaType.META, data, true);
        Set<String> editable = this.extractNames(attributes);
        Iterator iterator = meta.iterator();
        while (iterator.hasNext()) {
            FieldDTO fieldDTO;
            fieldDTO.setDisabled(Boolean.valueOf(!editable.contains((fieldDTO = (FieldDTO)iterator.next()).getKey())));
        }
        return new MetaDTO(new RowMetaDTO(this.getActions().toDto(bc), meta));
    }

    protected EngineFieldsMeta getMeta(BcIdentifier bc, RowMetaType type, D dataDto, boolean visibleOnly) {
        EngineFieldsMeta fieldsNode = new EngineFieldsMeta(this.objectMapper);
        Set<String> fields = this.getBCFields(bc, dataDto, visibleOnly);
        Map<String, Object> values = this.getValues(dataDto, fields);
        for (String dtoField : fields) {
            FieldDTO fieldDTO = FieldDTO.disabledField((String)dtoField);
            fieldDTO.setCurrentValue(values.get(dtoField));
            fieldsNode.add(fieldDTO);
        }
        return fieldsNode;
    }

    @Override
    public MetaDTO getMetaNew(BusinessComponent bc, CreateResult data) {
        Set<String> attributes = this.extractNames(this.getAttributes(bc));
        EngineFieldsMeta meta = this.getMeta((BcIdentifier)bc.getDescription(), RowMetaType.META_NEW, (D)((UniversalDTO)data.getRecord()), true);
        Iterator iterator = meta.iterator();
        while (iterator.hasNext()) {
            FieldDTO fieldDTO;
            fieldDTO.setDisabled(Boolean.valueOf(!attributes.contains((fieldDTO = (FieldDTO)iterator.next()).getKey())));
        }
        MetaDTO result = new MetaDTO(new RowMetaDTO(this.getActions().toDto(bc), meta));
        result.setPostActions(data.getPostActions());
        return result;
    }

    @Override
    public MetaDTO getMetaEmpty(BusinessComponent bc) {
        return this.buildMeta(Collections.emptyList(), this.getActions().toDto(bc));
    }

    public Actions<D> getActions() {
        return Actions.builder().save().available(this::isSaveAvailable).add().create().available(this::isCreateAvailable).add().delete().available(this::isDeleteAvailable).add().build();
    }

    @Override
    public ActionResultDTO invokeAction(BusinessComponent bc, String actionName, Map<String, Object> data) {
        return super.invokeAction(bc, actionName, data);
    }

    protected boolean isSaveAvailable(BusinessComponent bc) {
        return false;
    }

    protected boolean isCreateAvailable(BusinessComponent bc) {
        return false;
    }

    protected boolean isDeleteAvailable(BusinessComponent bc) {
        return false;
    }

    public D get(BusinessComponent bc) {
        List<Attribute<?, ?>> attributes = this.getAttributes(bc);
        Class<D> dtoClass = this.createDTOClass(attributes);
        return this.entityToDto(this.getEntity(bc), dtoClass, this.extractNames(attributes));
    }

    protected abstract E getEntity(BusinessComponent var1);

    public ResultPage<D> getAll(BusinessComponent bc) {
        List<Attribute<?, ?>> attributes = this.getAttributes(bc);
        Class<D> dtoClass = this.createDTOClass(attributes);
        Collection<E> entities = this.getEntities(bc);
        Set<String> names = this.extractNames(attributes);
        ArrayList<D> result = new ArrayList<D>();
        for (E entity : entities) {
            result.add(this.entityToDto(entity, dtoClass, names));
        }
        if (entities instanceof ResultPage) {
            return ResultPage.of(result, (boolean)((ResultPage)entities).isHasNext());
        }
        return ListPaging.getResultPage(result, bc.getParameters());
    }

    protected abstract Collection<? extends E> getEntities(BusinessComponent var1);

    protected Class<? extends D> createDTOClass(List<Attribute<?, ?>> attributes) {
        BeanGenerator generator = new BeanGenerator();
        generator.setSuperclass(this.getDtoClass());
        Set<String> ignored = this.getIgnoredAttributes();
        Consumer<Attribute> c = a -> generator.addProperty(a.getName(), a.getJavaType());
        attributes.stream().filter(a -> !ignored.contains(a.getName())).forEach(c);
        return (Class)generator.createClass();
    }

    protected List<Attribute<?, ?>> getAttributes(BusinessComponent bc) {
        return this.getEntityAttributes(this.getEntityClass(bc));
    }

    protected List<Attribute<?, ?>> getEntityAttributes(Class<? extends E> cls) {
        EntityType entityType = this.jpaDao.getEntityType(cls);
        return entityType.getAttributes().stream().map(attribute -> attribute).filter(attribute -> !attribute.isAssociation() && !attribute.isCollection()).collect(Collectors.toList());
    }

    protected Set<String> getIgnoredAttributes() {
        HashSet<String> result = new HashSet<String>();
        result.add(UniversalDTO_.id.getName());
        result.add(UniversalDTO_.vstamp.getName());
        return result;
    }

    protected List<Attribute<?, ?>> getAttributes(Class<? extends E> cls, Predicate<Attribute<?, ?>> predicate) {
        return this.getEntityAttributes(cls).stream().filter(predicate).collect(Collectors.toList());
    }

    protected Map<String, Object> getValues(Object entity, Set<String> attributes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.getPropertyDescriptors(entity).filter(pd -> attributes.contains(pd.getName())).forEach(pd -> result.put(pd.getName(), this.getValue(entity, (PropertyDescriptor)pd)));
        return result;
    }

    protected void setValues(Object entity, UniversalDTO dto, Set<String> attributes) {
        this.getPropertyDescriptors(entity).filter(pd -> attributes.contains(pd.getName())).forEach(pd -> this.writeValue(entity, dto.get(pd.getName()), (PropertyDescriptor)pd));
    }

    protected Set<String> extractNames(List<Attribute<?, ?>> attributes) {
        return attributes.stream().map(Attribute::getName).collect(Collectors.toSet());
    }

    private Object getValue(Object entity, PropertyDescriptor pd) {
        return pd.getReadMethod().invoke(entity, new Object[0]);
    }

    private void writeValue(Object entity, Object value, PropertyDescriptor pd) {
        pd.getWriteMethod().invoke(entity, value);
    }

    private Set<String> getBCFields(BcIdentifier bc, D dataDTO, boolean visibleOnly) {
        if (visibleOnly && this.extendedDtoFieldLevelSecurityService.isPresent()) {
            return this.extendedDtoFieldLevelSecurityService.get().getBcFieldsForCurrentScreen(bc);
        }
        return this.getPropertyDescriptors(dataDTO).map(FeatureDescriptor::getName).collect(Collectors.toSet());
    }

    private Stream<PropertyDescriptor> getPropertyDescriptors(Object object) {
        return Stream.of(Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()).filter(pd -> pd.getWriteMethod() != null);
    }

    @Generated
    public UniversalCrudmaService() {
    }
}

