/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.impl;

import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.system.ISystemSettingChangeEventListener;
import org.cxbox.api.system.SystemSettingChangedEvent;
import org.cxbox.api.system.SystemSettings;
import org.cxbox.core.exception.ExceptionHandlerSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExceptionHandlerSettingsImpl
implements ExceptionHandlerSettings,
ISystemSettingChangeEventListener {
    private boolean trackExceptions;
    private boolean fullStackTraces;
    @Autowired
    private SystemSettings systemSettings;

    public void onApplicationEvent(SystemSettingChangedEvent event) {
        if (CoreDictionaries.SystemPref.FEATURE_EXCEPTION_TRACKING.equals((Object)event.getSetting())) {
            this.trackExceptions = this.systemSettings.getBooleanValue(CoreDictionaries.SystemPref.FEATURE_EXCEPTION_TRACKING);
        }
        if (CoreDictionaries.SystemPref.FEATURE_FULL_STACKTRACES.equals((Object)event.getSetting())) {
            this.fullStackTraces = this.systemSettings.getBooleanValue(CoreDictionaries.SystemPref.FEATURE_FULL_STACKTRACES);
        }
    }

    @PostConstruct
    protected void init() {
        this.trackExceptions = this.systemSettings.getBooleanValue(CoreDictionaries.SystemPref.FEATURE_EXCEPTION_TRACKING);
        this.fullStackTraces = this.systemSettings.getBooleanValue(CoreDictionaries.SystemPref.FEATURE_FULL_STACKTRACES);
    }

    @Override
    @Generated
    public boolean isTrackExceptions() {
        return this.trackExceptions;
    }

    @Override
    @Generated
    public boolean isFullStackTraces() {
        return this.fullStackTraces;
    }

    @Generated
    public SystemSettings getSystemSettings() {
        return this.systemSettings;
    }
}

