/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.filter.provider.impl;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.util.DateTimeUtil;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.core.util.filter.provider.impl.DateValueProvider;

public abstract class AbstractClassifyDataProvider
implements ClassifyDataProvider {
    @Override
    public List<ClassifyDataParameter> getClassifyDataParameters(Field dtoField, FilterParameter filterParam, SearchParameter searchParam, List<ClassifyDataProvider> providers) {
        ClassifyDataParameter dataParameter = AbstractClassifyDataProvider.getBaseClassifyDataParameter(filterParam, searchParam);
        List<ClassifyDataParameter> baseClassifyDataParameterList = AbstractClassifyDataProvider.getBaseClassifyDataParameterList(dataParameter, filterParam, searchParam);
        if (baseClassifyDataParameterList != null) {
            return baseClassifyDataParameterList;
        }
        return this.getProviderParameterValues(dtoField, dataParameter, filterParam, searchParam, providers);
    }

    protected abstract List<ClassifyDataParameter> getProviderParameterValues(Field var1, ClassifyDataParameter var2, FilterParameter var3, SearchParameter var4, List<ClassifyDataProvider> var5);

    private static List<ClassifyDataParameter> getBaseClassifyDataParameterList(ClassifyDataParameter dataParameter, FilterParameter filterParameter, SearchParameter searchParameter) {
        ArrayList<ClassifyDataParameter> parameters = new ArrayList<ClassifyDataParameter>();
        if (searchParameter.suppressProcess()) {
            return parameters;
        }
        if (SearchOperation.SPECIFIED.equals((Object)dataParameter.getOperator())) {
            dataParameter.setValue(filterParameter.getBooleanValue());
            parameters.add(dataParameter);
            return parameters;
        }
        return null;
    }

    private static ClassifyDataParameter getBaseClassifyDataParameter(FilterParameter filterParameter, SearchParameter searchParameter) {
        String dtoFieldName = filterParameter.getName();
        return ClassifyDataParameter.builder().operator(filterParameter.getOperation()).provider(searchParameter.provider()).field(searchParameter.name().isEmpty() ? dtoFieldName : searchParameter.name()).build();
    }

    protected static void setClassifyDateParameterDateValue(ClassifyDataParameter dataParameter, FilterParameter param, boolean tzAware, SearchParameter parameter, List<ClassifyDataParameter> result) {
        switch (dataParameter.getOperator()) {
            case GREATER_OR_EQUAL_THAN: 
            case LESS_THAN: {
                dataParameter.setValue(param.getDateValue().with(DateTimeUtil.asStartOfDay()).with(DateTimeUtil.fromSession(tzAware)));
                if (!parameter.strict()) break;
                dataParameter.setValue(param.getDateValue().with(DateTimeUtil.fromSession(tzAware)));
                break;
            }
            case LESS_OR_EQUAL_THAN: 
            case GREATER_THAN: {
                dataParameter.setValue(param.getDateValue().with(DateTimeUtil.asEndOfDay()).with(DateTimeUtil.fromSession(tzAware)));
                if (!parameter.strict()) break;
                dataParameter.setValue(param.getDateValue().with(DateTimeUtil.fromSession(tzAware)));
                break;
            }
            case EQUALS: {
                LocalDateTime startValue = DateValueProvider.class.equals(parameter.provider()) ? param.getDateValue().with(DateTimeUtil.asStartOfDay()) : param.getDateValue().withSecond(0);
                dataParameter.setValue(startValue.with(DateTimeUtil.fromSession(tzAware)));
                dataParameter.setOperator(SearchOperation.GREATER_OR_EQUAL_THAN);
                ClassifyDataParameter dataParameterAdditional = ClassifyDataParameter.builder().operator(SearchOperation.LESS_THAN).field(dataParameter.getField()).build();
                if (DateValueProvider.class.equals(parameter.provider())) {
                    dataParameterAdditional.setValue(startValue.with(DateTimeUtil.asEndOfDay()).with(DateTimeUtil.fromSession(tzAware)));
                } else {
                    dataParameterAdditional.setValue(LocalDateTime.of(startValue.toLocalDate(), startValue.toLocalTime().plusMinutes(1L)).with(DateTimeUtil.fromSession(tzAware)));
                }
                result.add(dataParameterAdditional);
                break;
            }
            default: {
                dataParameter.setValue(param.getDateValue().with(DateTimeUtil.fromSession(tzAware)));
            }
        }
    }
}

