/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.core.util.SpringBeanUtils;
import org.cxbox.core.util.TypeConverter;

public interface QueryParameter {
    public static <T> T getValue(String value, Class<T> cls, T defaultValue) {
        return (T)Optional.ofNullable(value).map(v -> TypeConverter.to(cls, v)).orElse(defaultValue);
    }

    public static <T> List<T> getListValue(String stringValue, Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)stringValue)) {
            return Collections.emptyList();
        }
        ObjectMapper cxboxObjectMapper = (ObjectMapper)SpringBeanUtils.getBean("cxboxObjectMapper");
        List strings = (List)cxboxObjectMapper.readValue(stringValue, (TypeReference)new StringListTypeReference());
        return strings.stream().map(value -> TypeConverter.to(cls, value)).collect(Collectors.toList());
    }

    public String getName();

    public <R> R apply(BiFunction<String, String, R> var1);

    public static class StringListTypeReference
    extends TypeReference<List<String>> {
    }
}

