/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.file.service;

import jakarta.annotation.Nullable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.core.file.dto.FileDownloadDto;
import org.cxbox.core.file.service.CxboxFileService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
@ConditionalOnMissingBean(value={CxboxFileService.class})
public class CxboxFileServiceSimple
implements CxboxFileService {
    public static final String UNIQUE_PREFIX_SEPARATOR = ".";
    private final Path fileFolder;

    public CxboxFileServiceSimple(String fileFolder) {
        if (StringUtils.isEmpty((CharSequence)fileFolder)) {
            this.fileFolder = Files.createTempDirectory("files", new FileAttribute[0]);
        } else {
            this.fileFolder = Paths.get(fileFolder, new String[0]).toAbsolutePath().normalize();
            Files.createDirectories(this.fileFolder, new FileAttribute[0]);
        }
    }

    public String upload(@NonNull FileDownloadDto file, @Nullable String source) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String id = UUID.randomUUID().toString().replaceAll("-", "") + UNIQUE_PREFIX_SEPARATOR + file.getName();
        FileCopyUtils.copy((byte[])file.getBytes(), (OutputStream)Files.newOutputStream(this.getPathFromId(id), new OpenOption[0]));
        return id;
    }

    public FileDownloadDto download(@NonNull String id, @Nullable String source) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Path path = this.getPathFromId(id);
        return new FileDownloadDto(Files.readAllBytes(path), path.getFileName().toString().substring(0, path.getFileName().toString().indexOf(UNIQUE_PREFIX_SEPARATOR)), Files.probeContentType(path));
    }

    @Override
    public void remove(@NonNull String id, @Nullable String source) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Path path = this.getPathFromId(id);
        Files.deleteIfExists(path);
    }

    @NonNull
    private Path getPathFromId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Path fileId = Paths.get("/" + id, new String[0]).normalize();
        return Paths.get(this.fileFolder + "/" + fileId, new String[0]);
    }
}

