/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.exception.ServerException;
import org.cxbox.api.util.compare.CxComparatorUtils;
import org.cxbox.api.util.compare.common.Transformer;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.controller.param.SortParameter;
import org.cxbox.core.controller.param.SortParameters;
import org.cxbox.core.controller.param.SortType;
import org.cxbox.core.util.TypeConverter;

public final class ListPaging {
    public static <T extends DataResponseDTO> ResultPage<T> getResultPage(List<T> list, QueryParameters queryParameters) {
        Stream stream = list.stream();
        for (FilterParameter parameter : queryParameters.getFilter()) {
            stream = stream.filter(ListPaging.createFilter(parameter));
        }
        if (!queryParameters.getSort().isEmpty()) {
            stream = stream.sorted(ListPaging.createSorted(queryParameters.getSort()));
        }
        List filteredList = stream.toList();
        long from = (long)queryParameters.getPageNumber() * (long)queryParameters.getPageSize();
        long to = from + (long)queryParameters.getPageSize();
        if (to > (long)filteredList.size()) {
            to = filteredList.size();
        }
        return new ResultPage(filteredList.subList((int)from, (int)to), (long)filteredList.size() > to);
    }

    private static <T> Predicate<T> createFilter(FilterParameter parameter) {
        return switch (parameter.getOperation()) {
            case SearchOperation.CONTAINS -> new PredicateContains(parameter);
            case SearchOperation.SPECIFIED -> new PredicateSpecified(parameter);
            case SearchOperation.EQUALS -> new PredicateEquals(parameter);
            case SearchOperation.GREATER_THAN -> new PredicateGreaterThan(parameter);
            case SearchOperation.GREATER_OR_EQUAL_THAN -> new PredicateGreaterOrEqualThan(parameter);
            case SearchOperation.LESS_THAN -> new PredicateLessThan(parameter);
            case SearchOperation.LESS_OR_EQUAL_THAN -> new PredicateLessOrEqualThan(parameter);
            case SearchOperation.EQUALS_ONE_OF -> new PredicateEqualsOneOf(parameter);
            case SearchOperation.CONTAINS_ONE_OF -> new PredicateContainsOneOf(parameter);
            default -> throw new ServerException(String.format("Operation \"%s\" is not supported", new Object[]{parameter.getOperation()}));
        };
    }

    private static <T> Comparator<T> createSorted(SortParameters sort) {
        ArrayList sortedParameters = new ArrayList(sort.getParameters());
        sortedParameters.sort(CxComparatorUtils.transformedComparator((Comparator)CxComparatorUtils.nullHighComparator((Comparator)CxComparatorUtils.naturalComparator()), SortParameter::getPriority));
        ArrayList<Comparator<T>> comparators = new ArrayList<Comparator<T>>();
        for (SortParameter sortedParameter : sortedParameters) {
            comparators.add(ListPaging.createSorted(sortedParameter));
        }
        return CxComparatorUtils.chainedComparator(comparators);
    }

    private static <T, F extends Comparable<? super F>> Comparator<T> createSorted(SortParameter parameter) {
        FieldTransformer fieldTransformer = new FieldTransformer(parameter.getName());
        return switch (parameter.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case SortType.ASC -> CxComparatorUtils.transformedComparator((Comparator)CxComparatorUtils.nullHighComparator((Comparator)CxComparatorUtils.naturalComparator()), fieldTransformer);
            case SortType.DESC -> CxComparatorUtils.transformedComparator((Comparator)CxComparatorUtils.nullHighComparator((Comparator)CxComparatorUtils.reversedComparator((Comparator)CxComparatorUtils.naturalComparator())), fieldTransformer);
        };
    }

    private static <T> Object getValue(T dto, String fieldName) {
        try {
            return FieldUtils.getField(dto.getClass(), (String)fieldName, (boolean)true).get(dto);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Generated
    private ListPaging() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record PredicateContains<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            String str;
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof String && StringUtils.containsIgnoreCase((CharSequence)(str = (String)value), (CharSequence)this.parameter.getStringValue());
        }
    }

    private record PredicateSpecified<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return BooleanUtils.isNotFalse((Boolean)this.parameter.getBooleanValue()) ? Objects.nonNull(value) : Objects.isNull(value);
        }
    }

    private record PredicateEquals<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value != null && Objects.equals(value, this.parameter.getValue(value.getClass()));
        }
    }

    private record PredicateGreaterThan<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Comparable comp;
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && (comp = (Comparable)value).compareTo(this.parameter.getValue(value.getClass())) > 0;
        }
    }

    private record PredicateGreaterOrEqualThan<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Comparable comp;
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && (comp = (Comparable)value).compareTo(this.parameter.getValue(value.getClass())) >= 0;
        }
    }

    private record PredicateLessThan<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Comparable comp;
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && (comp = (Comparable)value).compareTo(this.parameter.getValue(value.getClass())) < 0;
        }
    }

    private record PredicateLessOrEqualThan<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Comparable comp;
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && (comp = (Comparable)value).compareTo(this.parameter.getValue(value.getClass())) <= 0;
        }
    }

    private record PredicateEqualsOneOf<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            for (String stringValue : this.parameter.getStringValuesAsList()) {
                if (value == null || !Objects.equals(value, TypeConverter.to(value.getClass(), stringValue))) continue;
                return true;
            }
            return false;
        }
    }

    private record PredicateContainsOneOf<T>(FilterParameter parameter) implements Predicate<T>
    {
        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            if (value instanceof String) {
                String str = (String)value;
                for (String stringValue : this.parameter.getStringValuesAsList()) {
                    if (!StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)stringValue)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private record FieldTransformer<T, F extends Comparable<? super F>>(String fieldName) implements Transformer<T, F>
    {
        public F transform(T input) {
            Object value = ListPaging.getValue(input, this.fieldName);
            try {
                if (value instanceof Comparable) {
                    Comparable comp = (Comparable)value;
                    return (F)comp;
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
    }
}

