/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.api.service.session.CxboxUserDetailsInterface;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.cxbox.core.util.session.UserExternalService;
import org.cxbox.model.core.api.EffectiveUserAware;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Service;

@Service
public class EffectiveUserAwareImpl
implements EffectiveUserAware<Long> {
    private final Optional<List<UserExternalService>> userExternalServices;
    private final CoreSessionService coreSessionService;

    private Long getSessionUserInternal(boolean fallbackToSystem) {
        CxboxUserDetailsInterface details = this.coreSessionService.getSessionUserDetails(false);
        if (details != null) {
            return details.getId();
        }
        Object sessionUser = null;
        if (this.userExternalServices.isPresent()) {
            UserExternalService userExternalService;
            Iterator<UserExternalService> iterator = this.userExternalServices.get().iterator();
            while (iterator.hasNext() && (sessionUser = (userExternalService = iterator.next()).getSessionUser()) == null) {
            }
        }
        if (sessionUser == null) {
            throw new SessionAuthenticationException("Not authorized");
        }
        Long user = (Long)sessionUser.getId();
        if (user == null && fallbackToSystem) {
            return InternalAuthorizationService.VANILLA.getId();
        }
        return user;
    }

    public Long getEffectiveSessionUser() {
        return this.getSessionUserInternal(true);
    }

    @ConstructorProperties(value={"userExternalServices", "coreSessionService"})
    @Generated
    public EffectiveUserAwareImpl(Optional<List<UserExternalService>> userExternalServices, CoreSessionService coreSessionService) {
        this.userExternalServices = userExternalServices;
        this.coreSessionService = coreSessionService;
    }
}

