/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.filter.provider.impl;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.cxbox.api.data.Period;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.util.DateTimeUtil;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.core.util.filter.provider.impl.AbstractClassifyDataProvider;
import org.springframework.stereotype.Component;

@Component
public class DateValueProvider
extends AbstractClassifyDataProvider
implements ClassifyDataProvider {
    @Override
    protected List<ClassifyDataParameter> getProviderParameterValues(Field dtoField, ClassifyDataParameter dataParameter, FilterParameter filterParam, SearchParameter searchParam, List<ClassifyDataProvider> providers) {
        ArrayList<ClassifyDataParameter> result = new ArrayList<ClassifyDataParameter>();
        if (SearchOperation.CONTAINS_ONE_OF.equals((Object)dataParameter.getOperator()) || SearchOperation.EQUALS_ONE_OF.equals((Object)dataParameter.getOperator())) {
            boolean tzAware = FieldDTO.isTzAware((Field)dtoField);
            ArrayList<Period> periods = new ArrayList<Period>();
            for (LocalDateTime value : filterParam.getDateValueAsList()) {
                LocalDateTime startValue = value.with(DateTimeUtil.asStartOfDay()).with(DateTimeUtil.fromSession(tzAware));
                LocalDateTime endValue = value.with(DateTimeUtil.asEndOfDay()).with(DateTimeUtil.fromSession(tzAware));
                periods.add(new Period((Object)startValue, (Object)endValue));
            }
            dataParameter.setValue(periods);
            dataParameter.setOperator(SearchOperation.INTERVALS);
        } else {
            DateValueProvider.setClassifyDateParameterDateValue(dataParameter, filterParam, FieldDTO.isTzAware((Field)dtoField), searchParam, result);
        }
        result.add(dataParameter);
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateValueProvider)) {
            return false;
        }
        DateValueProvider other = (DateValueProvider)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DateValueProvider;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

