/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.rowmeta.RowDependentFieldsDictionaryDeprecatedMeta;
import org.cxbox.dictionary.Dictionary;
import org.cxbox.dictionary.DictionaryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class RowDependentFieldsDictionaryMeta<T extends DataResponseDTO>
extends RowDependentFieldsDictionaryDeprecatedMeta<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RowDependentFieldsDictionaryMeta.class);
    private final Optional<DictionaryProvider> dictionaryProvider;

    public RowDependentFieldsDictionaryMeta(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, Optional<DictionaryProvider> dictionaryProvider) {
        super(objectMapper);
        this.dictionaryProvider = dictionaryProvider;
    }

    public final <V extends Dictionary> void setDictionaryValues(@Nullable DtoField<? super T, V> field, @NonNull Collection<V> variants) {
        if (variants == null) {
            throw new NullPointerException("variants is marked non-null but is null");
        }
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(Dictionary.of((Class)field.getValueClazz(), (String)"").getDictionaryType());
            List<SimpleDictionary> dictDTOList = this.mapDictionary(variants);
            fieldDTO.clearValues();
            fieldDTO.setValues(dictDTOList);
        });
    }

    <V extends Dictionary> List<SimpleDictionary> mapDictionary(Collection<V> variants) {
        ArrayList<SimpleDictionary> dictDTOList = new ArrayList<SimpleDictionary>();
        for (Dictionary variant : variants) {
            this.dictionaryProvider.ifPresent(p -> {
                DictionaryProvider.DictionaryValue dict = p.lookupValue(variant);
                if (dict != null) {
                    if (dict instanceof SimpleDictionary) {
                        SimpleDictionary simpleValue = (SimpleDictionary)dict;
                        dictDTOList.add(simpleValue);
                    } else {
                        dictDTOList.add(new SimpleDictionary(variant.key(), dict.getValue()));
                    }
                }
            });
        }
        return dictDTOList;
    }

    public final <V extends Dictionary> void setDictionaryValues(@Nullable DtoField<? super T, V> field) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            Collection variants = this.dictionaryProvider.map(e -> e.getAll(field.getValueClazz())).orElse(new ArrayList());
            this.setDictionaryValues(field, variants);
        });
    }

    @SafeVarargs
    public final <E extends Enum<?>> void setEnumValues(@Nullable DtoField<? super T, E> field, E ... values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (field != null) {
            this.setConcreteValues(field, Arrays.stream(values).map(en -> new SimpleDictionary(en.name(), this.serialize((Enum<?>)en))).collect(Collectors.toList()));
        }
    }

    String serialize(@NonNull Enum<?> en) {
        if (en == null) {
            throw new NullPointerException("en is marked non-null but is null");
        }
        String serialize = this.objectMapper.writeValueAsString(en);
        return serialize.substring(1, serialize.length() - 1);
    }
}

