/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session;

import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.api.service.session.CxboxUserDetailsInterface;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="coreSessionService")
public class CoreSessionServiceImpl
implements CoreSessionService {
    public String getSessionId() {
        return RequestContextHolder.currentRequestAttributes().getSessionId();
    }

    public CxboxUserDetailsInterface getSessionUserDetails(boolean raiseError) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            if (raiseError) {
                throw new SessionAuthenticationException("Not authorized");
            }
            return null;
        }
        CxboxUserDetailsInterface userDetails = this.getAuthenticationDetails(auth);
        if (userDetails == null && raiseError) {
            throw new SessionAuthenticationException("Not authorized");
        }
        return userDetails;
    }

    public CxboxUserDetailsInterface getAuthenticationDetails(Authentication auth) {
        if (auth == null) {
            return null;
        }
        return Stream.of(auth.getDetails(), auth.getPrincipal()).filter(CxboxUserDetailsInterface.class::isInstance).map(CxboxUserDetailsInterface.class::cast).findFirst().orElse(null);
    }

    public TimeZone getTimeZone(TimeZone defaultValue) {
        return Optional.ofNullable(this.getSessionUserDetails(false)).map(CxboxUserDetailsInterface::getTimezone).map(LOV::getKey).map(StringUtils::parseTimeZoneString).orElse(defaultValue);
    }

    public Locale getLocale(Locale defaultValue) {
        return Optional.ofNullable(this.getSessionUserDetails(false)).map(CxboxUserDetailsInterface::getLocaleCd).map(LOV::getKey).map(StringUtils::parseLocaleString).orElse(defaultValue);
    }
}

