/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.InfoMessageSource;
import org.cxbox.core.controller.BCFactory;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.CrudmaGateway;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.util.ResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{'${cxbox.api.path}'}"})
public class UniversalDataController {
    @Autowired
    private CrudmaGateway crudmaGateway;
    @Autowired
    private BCFactory bcFactory;
    @Autowired
    private CrudmaActionHolder crudmaActionHolder;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"data/**"})
    public ResponseDTO find(HttpServletRequest request, QueryParameters queryParameters) {
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        if (bc.getId() != null) {
            CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.GET).setBc(bc).getAction();
            crudmaAction.setDescription(String.format("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 %s, id: %s, parentId: %s", ((BcDescription)bc.getDescription()).getName(), bc.getId(), bc.getParentId()));
            DataResponseDTO data = this.crudmaGateway.get(crudmaAction);
            return ResponseBuilder.build(data == null ? Collections.emptyList() : Collections.singletonList(data));
        }
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.FIND).setBc(bc).getAction();
        crudmaAction.setDescription(InfoMessageSource.infoMessage((String)"info.get_list_request", (Object[])new Object[]{((BcDescription)bc.getDescription()).getName(), bc.getParentId()}));
        ResultPage<? extends DataResponseDTO> data = this.crudmaGateway.getAll(crudmaAction);
        return ResponseBuilder.build(data.getResult(), data.isHasNext());
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"data/**"})
    public ResponseDTO update(HttpServletRequest request, QueryParameters queryParameters, @RequestBody Map<String, Object> requestBody) {
        if (requestBody == null || requestBody.get("data") == null || !(requestBody.get("data") instanceof Map)) {
            throw new ClientException("Request with wrong request body. Expected: {\"data\":{}}");
        }
        requestBody = (Map)requestBody.get("data");
        String action = queryParameters.getParameter("_action");
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.UPDATE).setBc(bc).setOriginalActionType(action).setDescription(String.format("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 %s, id: %s, parentId: %s", ((BcDescription)bc.getDescription()).getName(), bc.getId(), bc.getParentId())).getAction();
        return ResponseBuilder.build(this.crudmaGateway.update(crudmaAction, requestBody));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"data/**"})
    public ResponseDTO delete(HttpServletRequest request, QueryParameters queryParameters) {
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        String action = queryParameters.getParameter("_action");
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.DELETE).setBc(bc).setOriginalActionType(action).setDescription(String.format("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 %s, id: %s, parentId: %s", ((BcDescription)bc.getDescription()).getName(), bc.getId(), bc.getParentId())).getAction();
        return ResponseBuilder.build(this.crudmaGateway.delete(crudmaAction));
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"count/**"})
    public ResponseDTO count(HttpServletRequest request, QueryParameters queryParameters) {
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.COUNT).setBc(bc).setDescription(String.format("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 %s, parentId: %s", ((BcDescription)bc.getDescription()).getName(), bc.getParentId())).getAction();
        return ResponseBuilder.build(this.crudmaGateway.count(crudmaAction));
    }
}

