/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.file.service;

import jakarta.annotation.Nullable;
import java.io.IOException;
import lombok.NonNull;
import org.cxbox.core.file.dto.FileDownloadDto;
import org.springframework.web.multipart.MultipartFile;

public interface CxboxFileService {
    public <D extends FileDownloadDto> String upload(@NonNull D var1, @Nullable String var2);

    default public String upload(@NonNull MultipartFile file, @Nullable String source) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return this.upload(new FileDownloadDto(() -> {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, file.getSize(), file.getOriginalFilename(), file.getContentType()), source);
    }

    public FileDownloadDto download(@NonNull String var1, @Nullable String var2);

    public void remove(@NonNull String var1, @Nullable String var2);
}

