/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.service.action.ActionAvailableChecker;
import org.cxbox.core.service.action.ActionDescription;
import org.cxbox.core.service.action.ActionDescriptionBuilder;
import org.cxbox.core.service.action.ActionGroupDescription;
import org.cxbox.core.service.action.ActionIconSpecifier;
import org.cxbox.core.service.action.ActionScope;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.action.ResponseServiceAction;

public class ActionsBuilder<T extends DataResponseDTO> {
    private final List<ActionDescription<T>> actionDefinitions = new ArrayList<ActionDescription<T>>();
    private final List<ActionGroupDescription<T>> actionGroupDefinitions = new ArrayList<ActionGroupDescription<T>>();
    private ActionDescriptionBuilder<T> actionDescriptionBuilder;

    ActionsBuilder() {
    }

    public ActionsBuilder<T> addAction(ActionDescription<T> actionDescription) {
        if (Objects.nonNull(actionDescription)) {
            this.actionDefinitions.add(actionDescription);
        }
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> newAction() {
        this.actionDescriptionBuilder = ActionDescription.builder().withBuilder(this);
        this.actionDescriptionBuilder.available(ActionAvailableChecker.ALWAYS_TRUE);
        return this.actionDescriptionBuilder;
    }

    public ActionsBuilder<T> action(UnaryOperator<ActionDescriptionBuilder<T>> descriptionBuilderConsumer) {
        ActionDescriptionBuilder lambdaActionBuilder = ActionDescription.builder().withBuilder(this);
        descriptionBuilderConsumer.apply(lambdaActionBuilder);
        ActionDescription actionDescription = lambdaActionBuilder.build();
        this.addAction(actionDescription);
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> action(String type, String actionName) {
        this.actionDescriptionBuilder = this.newAction();
        this.actionDescriptionBuilder.action(type, actionName);
        return this.actionDescriptionBuilder;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> action(ActionType actionType) {
        this.actionDescriptionBuilder = this.newAction().action(actionType);
        return this.actionDescriptionBuilder;
    }

    public ActionsBuilder<T> create(UnaryOperator<ActionDescriptionBuilder<T>> descriptionBuilderConsumer) {
        ActionDescriptionBuilder<T> lambdaActionBuilder = this.create();
        descriptionBuilderConsumer.apply(lambdaActionBuilder);
        ActionDescription<T> actionDescription = lambdaActionBuilder.build();
        this.addAction(actionDescription);
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> create() {
        this.actionDescriptionBuilder = this.action(ActionType.CREATE).scope(ActionScope.BC).withoutAutoSaveBefore();
        return this.actionDescriptionBuilder;
    }

    public ActionsBuilder<T> save(UnaryOperator<ActionDescriptionBuilder<T>> descriptionBuilderConsumer) {
        ActionDescriptionBuilder<T> lambdaActionBuilder = this.save();
        descriptionBuilderConsumer.apply(lambdaActionBuilder);
        ActionDescription<T> actionDescription = lambdaActionBuilder.build();
        this.addAction(actionDescription);
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> save() {
        this.actionDescriptionBuilder = this.action(ActionType.SAVE);
        return this.actionDescriptionBuilder;
    }

    public ActionsBuilder<T> cancelCreate(UnaryOperator<ActionDescriptionBuilder<T>> descriptionBuilderConsumer) {
        ActionDescriptionBuilder<T> lambdaActionBuilder = this.cancelCreate();
        descriptionBuilderConsumer.apply(lambdaActionBuilder);
        ActionDescription<T> actionDescription = lambdaActionBuilder.build();
        this.addAction(actionDescription);
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> cancelCreate() {
        this.actionDescriptionBuilder = this.action(ActionType.CANCEL_CREATE).available(ActionAvailableChecker.ALWAYS_FALSE).withoutAutoSaveBefore();
        return this.actionDescriptionBuilder;
    }

    public ActionsBuilder<T> associate(UnaryOperator<ActionDescriptionBuilder<T>> descriptionBuilderConsumer) {
        ActionDescriptionBuilder<T> lambdaActionBuilder = this.associate();
        descriptionBuilderConsumer.apply(lambdaActionBuilder);
        ActionDescription<T> actionDescription = lambdaActionBuilder.build();
        this.addAction(actionDescription);
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> associate() {
        this.actionDescriptionBuilder = this.action(ActionType.ASSOCIATE).scope(ActionScope.BC);
        return this.actionDescriptionBuilder;
    }

    public ActionsBuilder<T> delete(UnaryOperator<ActionDescriptionBuilder<T>> descriptionBuilderConsumer) {
        ActionDescriptionBuilder<T> lambdaActionBuilder = this.delete();
        descriptionBuilderConsumer.apply(lambdaActionBuilder);
        ActionDescription<T> actionDescription = lambdaActionBuilder.build();
        this.addAction(actionDescription);
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionDescriptionBuilder<T> delete() {
        this.actionDescriptionBuilder = this.action(ActionType.DELETE).withoutAutoSaveBefore();
        return this.actionDescriptionBuilder;
    }

    public ActionsBuilder<T> addGroup(String type, String groupName, int maxGroupVisualButtonsCount, Actions<T> groupActions) {
        this.actionGroupDefinitions.add(new ActionGroupDescription(type, groupName, maxGroupVisualButtonsCount, groupActions.actionDefinitions));
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionsBuilder<T> withIcon(ActionIconSpecifier icon, boolean showOnlyIcon) {
        this.actionGroupDefinitions.get(this.actionGroupDefinitions.size() - 1).setIconCode(icon);
        this.actionGroupDefinitions.get(this.actionGroupDefinitions.size() - 1).setShowOnlyIcon(showOnlyIcon);
        return this;
    }

    public ActionsBuilder<T> addAll(Actions<T> actions) {
        this.actionDefinitions.addAll(actions.actionDefinitions);
        this.actionGroupDefinitions.addAll(actions.actionGroupDefinitions);
        return this;
    }

    public ActionsBuilder<T> add(String key, ResponseServiceAction<T> responseServiceAction) {
        this.actionDefinitions.add(new ActionDescription<DataResponseDTO>(key, responseServiceAction.getButtonName(), responseServiceAction.getCustomParameters(), responseServiceAction::isAvailable, responseServiceAction::invoke, responseServiceAction::preActionSpecifier, responseServiceAction::preActionEventSpecifier, responseServiceAction::dataValidator, responseServiceAction.getIcon().getActionIconCode(), responseServiceAction.isIconWithText(), responseServiceAction.getScope(), responseServiceAction.isAutoSaveBefore()));
        return this;
    }

    public Actions<T> build() {
        return new Actions<T>(this.actionDefinitions, this.actionGroupDefinitions);
    }
}

