/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.cxbox.api.data.dto.AssociateDTO;
import org.cxbox.api.util.i18n.InfoMessageSource;
import org.cxbox.core.controller.BCFactory;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.CrudmaGateway;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.util.ResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{'${cxbox.api.path}'}/associate/**"})
public class UniversalAssociateController {
    @Autowired
    @Qualifier(value="cxboxObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private CrudmaGateway crudmaGateway;
    @Autowired
    private BCFactory bcFactory;
    @Autowired
    private CrudmaActionHolder crudmaActionHolder;

    @RequestMapping(method={RequestMethod.POST})
    public ResponseDTO associate(HttpServletRequest request, QueryParameters queryParameters, @RequestBody List<Object> data) {
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        if (data == null) {
            throw new ClientException("request must contain body");
        }
        String action = queryParameters.getParameter("_action");
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.ASSOCIATE).setBc(bc).setOriginalActionType(action).setDescription(InfoMessageSource.infoMessage((String)"info.associate_request", (Object[])new Object[]{((BcDescription)bc.getDescription()).getName(), bc.getId(), bc.getParentId()})).getAction();
        return ResponseBuilder.build(this.crudmaGateway.associate(crudmaAction, this.convertData(data)));
    }

    private List<AssociateDTO> convertData(List<Object> data) {
        ArrayList<AssociateDTO> result = new ArrayList<AssociateDTO>();
        data.forEach(d -> result.add((AssociateDTO)this.objectMapper.convertValue(d, AssociateDTO.class)));
        return result;
    }
}

