/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.core.controller.param.BaseParameterHolder;
import org.cxbox.core.controller.param.BindsParameters;
import org.cxbox.core.controller.param.DateStep;
import org.cxbox.core.controller.param.FilterParameters;
import org.cxbox.core.controller.param.ParameterBuilder;
import org.cxbox.core.controller.param.ParameterHolder;
import org.cxbox.core.controller.param.QueryParameter;
import org.cxbox.core.controller.param.SortParameters;
import org.cxbox.core.controller.param.resolvers.PageParameterArgumentResolver;
import org.cxbox.core.util.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParameters {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryParameters.class);
    public static final String DATE_FROM = "_dateFrom";
    public static final String DATE_TO = "_date";
    public static final String DATE_STEP = "_dateStep";
    public static final String EXPORT = "_export";
    public static final String X_AXIS = "_xAxis";
    public static final String Y_AXIS = "_yAxis";
    public static final String PDQ = "_pdq";
    public static final String IS_FILTERABLE_DATA = "_isFilterableData";
    public static final String PRE_INVOKE_EVENT_KEYS = "_preInvokeEventKeys";
    public static final String DEBUG_MODE = "_debugMode";
    private final Map<String, String> parameters;
    private final LocalDateTime currentDate;

    public QueryParameters(Map<String, String> parameters) {
        this(parameters, DateTimeUtil.now());
    }

    public QueryParameters(Map<String, String> parameters, LocalDateTime currentDate) {
        this.parameters = new HashMap<String, String>(parameters);
        this.currentDate = currentDate;
    }

    public static QueryParameters of(ParameterHolder<?> holder) {
        QueryParameters result = new QueryParameters(new HashMap<String, String>());
        return result.store(holder);
    }

    public static QueryParameters onlyDatesQueryParameters(QueryParameters other) {
        HashMap<String, String> dates = new HashMap<String, String>();
        dates.put(DATE_FROM, other.getParameter(DATE_FROM));
        dates.put(DATE_TO, other.getParameter(DATE_TO));
        return new QueryParameters(dates, other.currentDate);
    }

    public static QueryParameters emptyQueryParameters() {
        return new QueryParameters(new HashMap<String, String>());
    }

    private static LocalDateTime parseDate(String stringValue, LocalDateTime defaultValue) {
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return DateTimeUtil.stringToDateTime(stringValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getExportType() {
        return this.getParameter(EXPORT);
    }

    public String getAxisX() {
        return this.getParameter(X_AXIS);
    }

    public String getAxisY() {
        return this.getParameter(Y_AXIS);
    }

    public boolean isFilterableData() {
        return "TRUE".equalsIgnoreCase(this.getParameter(IS_FILTERABLE_DATA));
    }

    public boolean isDebug() {
        return "TRUE".equalsIgnoreCase(this.getParameter(DEBUG_MODE));
    }

    public DateStep getDateStep() {
        return DateStep.of(this.getParameter(DATE_STEP), DateStep.DAY);
    }

    public LocalDateTime getDateTo() {
        return QueryParameters.parseDate(this.getParameter(DATE_TO), this.currentDate);
    }

    public LocalDateTime getDateFrom() {
        return QueryParameters.parseDate(this.getParameter(DATE_FROM), this.currentDate);
    }

    public String getPdqName() {
        return this.getParameter(PDQ);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String setParameter(String name, String value) {
        return this.parameters.put(name, value);
    }

    public String removeParameter(String name) {
        return this.parameters.remove(name);
    }

    public boolean removeParameter(String name, String value) {
        return this.parameters.remove(name, value);
    }

    public boolean removeParameter(QueryParameter parameter) {
        return parameter.apply(this.parameters::remove);
    }

    public PageSpecification getPage() {
        return PageParameterArgumentResolver.extract(this.parameters);
    }

    public FilterParameters getFilter() {
        return FilterParameters.fromMap(this.parameters);
    }

    public QueryParameters store(ParameterHolder<?> holder) {
        this.removeMatched(holder.getBuilder());
        holder.forEach(this::setParameter);
        return this;
    }

    public <T extends QueryParameter> ParameterHolder<T> of(ParameterBuilder<T> builder) {
        return new BaseParameterHolder<T>(builder.buildParameters(this.parameters), builder);
    }

    public BindsParameters getBinds() {
        return BindsParameters.fromMap(this.parameters);
    }

    public SortParameters getSort() {
        return SortParameters.fromMap(this.parameters);
    }

    public List<String> getPreInvokeParameters() {
        return QueryParameter.getListValue(this.getParameter(PRE_INVOKE_EVENT_KEYS), String.class);
    }

    private void removeMatched(ParameterBuilder builder) {
        this.parameters.entrySet().removeIf(e -> builder.matches((String)e.getKey(), (String)e.getValue()));
    }

    public String setParameter(QueryParameter parameter) {
        return parameter.apply(this::setParameter);
    }

    public int getPageNumber() {
        return Optional.ofNullable(this.getPage()).map(PageSpecification::getPageNo).orElse(0);
    }

    public int getPageSize() {
        return Optional.ofNullable(this.getPage()).map(PageSpecification::getPageSize).orElse(0);
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public LocalDateTime getCurrentDate() {
        return this.currentDate;
    }

    @Generated
    public String toString() {
        return "QueryParameters(parameters=" + this.getParameters() + ", currentDate=" + this.getCurrentDate() + ")";
    }
}

