/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma;

import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.PlatformRequest;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.util.SpringBeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.context.request.RequestContextHolder;

@Component
@RequestScope
public class CrudmaActionHolder
implements PlatformRequest {
    private CrudmaAction crudmaAction;

    public static CrudmaActionType getActionType() {
        return Optional.ofNullable(CrudmaActionHolder.getCrudmaAction()).map(CrudmaAction::getActionType).orElse(null);
    }

    public static CrudmaAction getCrudmaAction() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            return Optional.ofNullable(SpringBeanUtils.getBean(CrudmaActionHolder.class)).map(CrudmaActionHolder::getAction).orElse(null);
        }
        return null;
    }

    @Deprecated
    public static QueryParameters getQueryParameters() {
        return Optional.ofNullable(CrudmaActionHolder.getCrudmaAction()).map(CrudmaAction::getBc).map(BusinessComponent::getParameters).orElse(QueryParameters.emptyQueryParameters());
    }

    @Override
    public BusinessComponent getBc() {
        return Optional.ofNullable(CrudmaActionHolder.getCrudmaAction()).map(CrudmaAction::getBc).orElse(null);
    }

    @Override
    public CrudmaActionType getCrudmaActionType() {
        return CrudmaActionHolder.getActionType();
    }

    public CrudmaAction getAction() {
        return this.crudmaAction;
    }

    public CrudmaActionHolder of(CrudmaActionType actionType) {
        this.crudmaAction = new SimpleCrudmaAction(actionType);
        return this;
    }

    public CrudmaActionHolder setDescription(String description) {
        Objects.requireNonNull(this.crudmaAction).setDescription(description);
        return this;
    }

    public CrudmaActionHolder setName(String name) {
        Objects.requireNonNull(this.crudmaAction).setName(name);
        return this;
    }

    public CrudmaActionHolder setBc(BusinessComponent bc) {
        Objects.requireNonNull(this.crudmaAction).setBc(bc);
        return this;
    }

    public CrudmaActionHolder setOriginalActionType(String originalActionType) {
        Objects.requireNonNull(this.crudmaAction).setOriginalActionType(originalActionType);
        return this;
    }

    public static interface CrudmaAction {
        public String toString();

        public CrudmaActionType getActionType();

        public String getDescription();

        public String getName();

        public BusinessComponent getBc();

        public String getOriginalActionType();

        public CrudmaAction setDescription(String var1);

        public CrudmaAction setName(String var1);

        public CrudmaAction setBc(BusinessComponent var1);

        public CrudmaAction setOriginalActionType(String var1);
    }

    public static class SimpleCrudmaAction
    implements CrudmaAction {
        private final CrudmaActionType actionType;
        private String description;
        private String name;
        private BusinessComponent bc;
        private String originalActionType;

        @ConstructorProperties(value={"actionType"})
        @Generated
        public SimpleCrudmaAction(CrudmaActionType actionType) {
            this.actionType = actionType;
        }

        @Override
        @Generated
        public String toString() {
            return "CrudmaActionHolder.SimpleCrudmaAction(actionType=" + this.getActionType() + ", description=" + this.getDescription() + ", name=" + this.getName() + ", bc=" + this.getBc() + ", originalActionType=" + this.getOriginalActionType() + ")";
        }

        @Override
        @Generated
        public CrudmaActionType getActionType() {
            return this.actionType;
        }

        @Override
        @Generated
        public SimpleCrudmaAction setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public SimpleCrudmaAction setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public SimpleCrudmaAction setBc(BusinessComponent bc) {
            this.bc = bc;
            return this;
        }

        @Override
        @Generated
        public BusinessComponent getBc() {
            return this.bc;
        }

        @Override
        @Generated
        public String getOriginalActionType() {
            return this.originalActionType;
        }

        @Override
        @Generated
        public SimpleCrudmaAction setOriginalActionType(String originalActionType) {
            this.originalActionType = originalActionType;
            return this;
        }
    }
}

