/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.cxbox.core.crudma.Crudma;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrudmaFactory {
    @Autowired
    private List<Crudma> crudmaList;

    public Crudma get(BcDescription bcDescription) {
        return this.crudmaList.stream().filter(crudma -> this.applyFilter((Crudma)crudma, bcDescription)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find bean with class " + bcDescription.getCrudmaService().getSimpleName()));
    }

    private boolean applyFilter(Crudma crudma, BcDescription bcDescription) {
        if (AopUtils.isAopProxy((Object)crudma)) {
            Advised advised = (Advised)crudma;
            Class aClass = Optional.of(advised).map(Advised::getTargetSource).map(src -> {
                try {
                    return src.getTarget();
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }).map(Object::getClass).orElse(null);
            return ClassUtils.isAssignable((Class)aClass, bcDescription.getCrudmaService());
        }
        return Objects.equals(crudma.getClass(), bcDescription.getCrudmaService());
    }
}

