/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.ext.impl;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.Invoker;
import org.cxbox.core.crudma.Crudma;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.CrudmaEvent;
import org.cxbox.core.crudma.CrudmaFactory;
import org.cxbox.core.crudma.InterimResult;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.ext.CrudmaGatewayInvokeExtensionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=300)
public class EventPublisherCrudmaGatewayInvokeExtensionProvider
implements CrudmaGatewayInvokeExtensionProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventPublisherCrudmaGatewayInvokeExtensionProvider.class);
    private final ApplicationEventPublisher eventPublisher;
    private final CrudmaFactory crudmaFactory;

    @Override
    public <T> Invoker<T, RuntimeException> extendInvoker(CrudmaActionHolder.CrudmaAction crudmaAction, Invoker<T, RuntimeException> invoker, boolean readOnly) {
        return () -> {
            Object bc;
            Function<Object, Object> resultExtractor;
            Object result = null;
            Exception exception = null;
            if (crudmaAction.getActionType().equals((Object)CrudmaActionType.CREATE)) {
                resultExtractor = t -> ((InterimResult)t).getDto();
            } else if (crudmaAction.getActionType().equals((Object)CrudmaActionType.PREVIEW)) {
                resultExtractor = t -> ((InterimResult)t).getMeta();
            } else if (crudmaAction.getActionType().equals((Object)CrudmaActionType.DELETE)) {
                bc = crudmaAction.getBc();
                Crudma crudma = this.crudmaFactory.get((BcDescription)((BusinessComponent)bc).getDescription());
                DataResponseDTO dataResponseDTO = crudma.get((BusinessComponent)bc);
                resultExtractor = resultDTO -> dataResponseDTO;
            } else {
                resultExtractor = Function.identity();
            }
            try {
                log.debug(crudmaAction.getDescription());
                bc = result = invoker.invoke();
                this.eventPublisher.publishEvent(new CrudmaEvent<Object>(this, crudmaAction, result == null ? null : resultExtractor.apply(result), exception));
            }
            catch (Exception ex) {
                try {
                    exception = ex;
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.eventPublisher.publishEvent(new CrudmaEvent<Object>(this, crudmaAction, result == null ? null : resultExtractor.apply(result), exception));
                    throw throwable;
                }
            }
            return bc;
        };
    }

    @ConstructorProperties(value={"eventPublisher", "crudmaFactory"})
    @Generated
    public EventPublisherCrudmaGatewayInvokeExtensionProvider(ApplicationEventPublisher eventPublisher, CrudmaFactory crudmaFactory) {
        this.eventPublisher = eventPublisher;
        this.crudmaFactory = crudmaFactory;
    }
}

