/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl;

import jakarta.persistence.LockModeType;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.config.properties.UIProperties;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.exception.UnableToLockException;
import org.cxbox.core.exception.VersionMismatchException;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.model.core.entity.AbstractEntity;
import org.cxbox.model.core.entity.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class VersionAwareResponseService<T extends DataResponseDTO, E extends BaseEntity>
extends AbstractResponseService<T, E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionAwareResponseService.class);
    @Autowired
    private UIProperties uiProperties;

    public VersionAwareResponseService(Class<T> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<T>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    public VersionAwareResponseService() {
    }

    @Override
    public CreateResult<T> createEntity(BusinessComponent bc) {
        E entity = this.create(bc);
        if (entity.getId() == null && bc.getId() != null) {
            entity.setId(bc.getIdAsLong());
        }
        CreateResult<T> createResult = this.doCreateEntity(entity, bc);
        this.baseDAO.flush();
        this.baseDAO.refresh((AbstractEntity)entity);
        return createResult;
    }

    protected E create(BusinessComponent bc) {
        return (E)((BaseEntity)this.typeOfEntity.newInstance());
    }

    @Override
    public ActionResultDTO<T> updateEntity(BusinessComponent bc, DataResponseDTO data) {
        return this.doUpdateEntity(this.loadEntity(bc, data), (DataResponseDTO)this.typeOfDTO.cast(data), bc);
    }

    @Override
    public ActionResultDTO<T> preview(BusinessComponent bc, DataResponseDTO data) {
        return this.doPreview(this.loadEntity(bc, data), (DataResponseDTO)this.typeOfDTO.cast(data), bc);
    }

    @Override
    protected E loadEntity(BusinessComponent bc, DataResponseDTO data) {
        Object entity = this.isExist(bc.getIdAsLong());
        if (!Objects.equals(data.getVstamp(), -1L) && !Objects.equals(entity.getVstamp(), data.getVstamp())) {
            throw new VersionMismatchException((BaseEntity)entity, data);
        }
        try {
            this.baseDAO.lock((AbstractEntity)entity, LockModeType.PESSIMISTIC_WRITE, this.getLockTimeout());
        }
        catch (OptimisticLockException | PessimisticLockException ex) {
            log.error(ex.getLocalizedMessage(), ex);
            this.baseDAO.clear();
            entity = this.isExist(bc.getIdAsLong());
            throw new VersionMismatchException((BaseEntity)entity, data);
        }
        catch (LockTimeoutException ex) {
            log.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new UnableToLockException();
        }
        return entity;
    }

    protected abstract CreateResult<T> doCreateEntity(E var1, BusinessComponent var2);

    protected abstract ActionResultDTO<T> doUpdateEntity(E var1, T var2, BusinessComponent var3);

    protected ActionResultDTO<T> doPreview(E entity, T data, BusinessComponent bc) {
        return this.doUpdateEntity(entity, data, bc);
    }

    protected int getLockTimeout() {
        return this.uiProperties.getUiLockTimeoutMs();
    }
}

