/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.mapper;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.mapper.RequestValueCache;
import org.cxbox.core.dto.mapper.RequestValueSupplier;
import org.cxbox.core.dto.mapper.ValueSupplier;
import org.cxbox.model.core.entity.BaseEntity;

public class Mapping<E extends BaseEntity, D extends DataResponseDTO> {
    private final Map<ValueSupplier<? super E, ? super D, ?>, Optional<?>> cache = new HashMap();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final RequestValueCache requestCache;
    private final Map<DtoField<? super D, ?>, ValueSupplier<? super E, ? super D, ?>> valueSuppliers;
    private final E entity;

    public <V> Optional<V> get(ValueSupplier<? super E, ? super D, V> valueSupplier) {
        Optional value = this.cache.computeIfAbsent(valueSupplier, key -> Optional.ofNullable(valueSupplier.get(this, (E)this.entity)));
        return value;
    }

    public <V> Optional<V> get(DtoField<? super D, ? super V> field) {
        ValueSupplier<? super E, ? super D, ?> valueSupplier = this.valueSuppliers.get(field);
        if (valueSupplier == null) {
            return Optional.empty();
        }
        return this.get(valueSupplier);
    }

    public <V> Optional<V> get(RequestValueSupplier<? super E, ? super D, V> valueSupplier) {
        Object key = valueSupplier.getKeySupplier().get(this, this.entity);
        return this.requestCache.computeIfAbsent(valueSupplier, key, () -> valueSupplier.getValueSupplier().get(this, this.entity));
    }

    public <V> Optional<V> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    void addAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @ConstructorProperties(value={"requestCache", "valueSuppliers", "entity"})
    @Generated
    public Mapping(RequestValueCache requestCache, Map<DtoField<? super D, ?>, ValueSupplier<? super E, ? super D, ?>> valueSuppliers, E entity) {
        this.requestCache = requestCache;
        this.valueSuppliers = valueSuppliers;
        this.entity = entity;
    }
}

