/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.api.data.dto.rowmeta.FieldsDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.FieldDrillDown;
import org.cxbox.core.service.action.DrillDownTypeSpecifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class RowDependentFieldsCommonMeta<T extends DataResponseDTO>
extends FieldsDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RowDependentFieldsCommonMeta.class);
    @Qualifier(value="cxboxObjectMapper")
    protected final ObjectMapper objectMapper;

    public RowDependentFieldsCommonMeta(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public FieldDTO get(DtoField<? super T, ?> field) {
        return (FieldDTO)this.fields.get(field.getName());
    }

    @NonNull
    public <F> Optional<F> getCurrentValue(@NonNull DtoField<? super T, F> field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (field.getValueClazz() != null) {
            return Optional.ofNullable(this.get(field)).filter(e -> e.getCurrentValue() != null).filter(e -> field.getValueClazz().isInstance(e.getCurrentValue())).map(e -> field.getValueClazz().cast(e.getCurrentValue()));
        }
        return Optional.ofNullable(this.get(field)).filter(e -> e.getCurrentValue() != null).map(e -> {
            try {
                return e.getCurrentValue();
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        });
    }

    public final void addConcreteValue(DtoField<? super T, ?> field, SimpleDictionary dictDTO) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.addValue(dictDTO));
    }

    @SafeVarargs
    public final void setRequired(DtoField<? super T, ?> ... fields) {
        this.required(true, fields);
    }

    @SafeVarargs
    public final void setNotRequired(DtoField<? super T, ?> ... fields) {
        this.required(false, fields);
    }

    @SafeVarargs
    public final void required(boolean required, DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setRequired(Boolean.valueOf(required))));
    }

    @SafeVarargs
    public final void setHidden(DtoField<? super T, ?> ... fields) {
        this.hidden(true, fields);
    }

    @SafeVarargs
    public final void setNotHidden(DtoField<? super T, ?> ... fields) {
        this.hidden(false, fields);
    }

    @SafeVarargs
    public final void hidden(boolean required, DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setHidden(Boolean.valueOf(required))));
    }

    public final void disableFields() {
        this.fields.values().forEach(fieldDTO -> fieldDTO.setDisabled(Boolean.valueOf(true)));
    }

    @SafeVarargs
    public final void setDisabled(DtoField<? super T, ?> ... fields) {
        this.disable(true, fields);
    }

    @SafeVarargs
    public final void setEnabled(DtoField<? super T, ?> ... fields) {
        this.disable(false, fields);
    }

    public final void disable(boolean disabled, DtoField<? super T, ?> ... fields) {
        List<String> fieldsList = Stream.of(fields).map(DtoField::getName).collect(Collectors.toList());
        this.disable(disabled, fieldsList);
    }

    public void setDisabled(List<String> fields) {
        this.disable(true, fields);
    }

    private final void disable(boolean disabled, List<String> fields) {
        fields.forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField)).ifPresent(fieldDTO -> fieldDTO.setDisabled(Boolean.valueOf(disabled))));
    }

    public final void setConcreteValues(DtoField<? super T, ?> field, Collection<SimpleDictionary> dictDtoList) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(field.getName());
            fieldDTO.clearValues();
            fieldDTO.setValues(dictDtoList);
        });
    }

    public final void setDrilldown(DtoField<? super T, ?> field, DrillDownTypeSpecifier drillDownType, String drillDown) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDrillDown(drillDown);
            fieldDTO.setDrillDownType(drillDownType.getValue());
        });
    }

    public final void setDrilldowns(List<FieldDrillDown> drillDowns) {
        for (FieldDrillDown drillDown : drillDowns) {
            Optional.ofNullable(drillDown).map(dd -> (FieldDTO)this.fields.get(dd.getTaskField())).ifPresent(fieldDTO -> {
                fieldDTO.setDrillDown(drillDown.getUrl());
                fieldDTO.setDrillDownType(drillDown.getType().getValue());
            });
        }
    }

    public final <V> void setCurrentValue(DtoField<? super T, V> field, V value) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setCurrentValue(value));
    }

    public final void setPlaceholder(DtoField<? super T, ?> field, String placeholder) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setPlaceholder(placeholder));
    }
}

