/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.file.controller;

import lombok.Generated;
import org.cxbox.core.file.controller.CxboxFileController;
import org.cxbox.core.file.dto.CxboxResponseDTO;
import org.cxbox.core.file.dto.FileDownloadDto;
import org.cxbox.core.file.dto.FileUploadDto;
import org.cxbox.core.file.service.CxboxFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

public abstract class AbstractCxboxFileController
implements CxboxFileController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCxboxFileController.class);
    @Autowired
    private CxboxFileService cxboxFileService;

    @PostMapping(consumes={"multipart/form-data"})
    public CxboxResponseDTO<FileUploadDto> upload(MultipartFile file, String source) {
        String id = this.cxboxFileService.upload(file, source);
        return new CxboxResponseDTO<FileUploadDto>().setData(new FileUploadDto(id, file.getOriginalFilename(), file.getContentType()));
    }

    @Override
    @GetMapping
    public HttpEntity<StreamingResponseBody> download(String id, String source, boolean preview) {
        FileDownloadDto file = this.cxboxFileService.download(id, source);
        return this.buildFileHttpEntity(file.getContent().get(), file.getLength(), file.getName(), file.getType(), preview);
    }

    @Override
    @DeleteMapping
    public CxboxResponseDTO<Void> remove(String id, String source) {
        this.cxboxFileService.remove(id, source);
        return new CxboxResponseDTO<Void>();
    }
}

