/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.dto.rowmeta.PreAction;
import org.cxbox.core.service.action.ActionAvailableChecker;
import org.cxbox.core.service.action.ActionDescription;
import org.cxbox.core.service.action.ActionIconSpecifier;
import org.cxbox.core.service.action.ActionInvoker;
import org.cxbox.core.service.action.ActionScope;
import org.cxbox.core.service.action.ActionsBuilder;
import org.cxbox.core.service.action.CxboxActionIconSpecifier;
import org.cxbox.core.service.action.DataValidator;
import org.cxbox.core.service.action.PreActionEvent;
import org.cxbox.core.service.action.PreActionEventSpecifier;
import org.cxbox.core.service.action.PreActionSpecifier;
import org.cxbox.core.service.action.PreActionSpecifierType;

public class ActionDescriptionBuilder<T extends DataResponseDTO> {
    private String key;
    private String text;
    private ActionAvailableChecker baseActionAvailableChecker;
    private ActionAvailableChecker actionAvailableChecker;
    private ActionInvoker<T> actionInvoker;
    private PreActionSpecifier preActionSpecifier;
    private PreActionEventSpecifier preActionEventSpecifier;
    private DataValidator<T> dataValidator;
    private ActionsBuilder<T> actionsBuilder;
    private ActionIconSpecifier iconCode = CxboxActionIconSpecifier.WITHOUT_ICON;
    private boolean showOnlyIcon = false;
    private ActionScope actionScope = ActionScope.RECORD;
    private Map<String, String> customParameter;
    private Boolean updateRequired;
    private boolean autoSaveBefore = true;

    private static <T extends DataResponseDTO> ActionInvoker<T> withoutUpdate(final ActionInvoker<T> wrapped) {
        return new ActionInvoker<T>(){

            @Override
            public ActionResultDTO<T> invoke(BusinessComponent bc, T data) {
                return wrapped.invoke(bc, data);
            }

            @Override
            public boolean isUpdateRequired() {
                return false;
            }
        };
    }

    private static <T extends DataResponseDTO> ActionInvoker<T> withUpdate(final ActionInvoker<T> wrapped) {
        return new ActionInvoker<T>(){

            @Override
            public ActionResultDTO<T> invoke(BusinessComponent bc, T data) {
                return wrapped.invoke(bc, data);
            }

            @Override
            public boolean isUpdateRequired() {
                return true;
            }
        };
    }

    public ActionDescriptionBuilder<T> action(String key, String text) {
        this.key = key;
        this.text = text;
        return this;
    }

    public ActionDescriptionBuilder<T> action(ActionType actionType) {
        if (Objects.nonNull((Object)actionType)) {
            this.key = actionType.getType();
            this.text = actionType.getText().get();
            this.iconCode = actionType.getIcon();
            this.showOnlyIcon = true;
            this.baseActionAvailableChecker = actionType.getBaseAvailableChecker();
        }
        return this;
    }

    public ActionDescriptionBuilder<T> available(ActionAvailableChecker actionAvailableChecker) {
        this.actionAvailableChecker = actionAvailableChecker;
        return this;
    }

    public ActionDescriptionBuilder<T> invoker(ActionInvoker<T> actionInvoker) {
        this.actionInvoker = actionInvoker;
        return this;
    }

    public ActionDescriptionBuilder<T> text(String text) {
        this.text = text;
        return this;
    }

    public ActionDescriptionBuilder<T> withPreAction(PreActionSpecifier preActionSpecifier) {
        this.preActionSpecifier = preActionSpecifier;
        return this;
    }

    public ActionDescriptionBuilder<T> withPreAction(PreAction preAction) {
        this.preActionSpecifier = bc -> preAction;
        return this;
    }

    public ActionDescriptionBuilder<T> withIcon(ActionIconSpecifier icon, boolean showOnlyIcon) {
        this.iconCode = icon;
        this.showOnlyIcon = showOnlyIcon;
        return this;
    }

    public ActionDescriptionBuilder<T> scope(ActionScope actionScope) {
        this.actionScope = actionScope;
        return this;
    }

    public ActionDescriptionBuilder<T> withCustomParameter(Map<String, String> parametersTuple) {
        this.customParameter = parametersTuple;
        return this;
    }

    public ActionDescriptionBuilder<T> withAutoSaveBefore() {
        this.autoSaveBefore = true;
        return this;
    }

    public ActionDescriptionBuilder<T> withoutAutoSaveBefore() {
        this.autoSaveBefore = false;
        return this;
    }

    public ActionDescriptionBuilder<T> withoutIcon() {
        this.iconCode = CxboxActionIconSpecifier.WITHOUT_ICON;
        this.showOnlyIcon = false;
        return this;
    }

    public ActionDescriptionBuilder<T> withPreActionEvents(PreActionEventSpecifier preActionEventSpecifier) {
        this.preActionEventSpecifier = preActionEventSpecifier;
        return this;
    }

    public ActionDescriptionBuilder<T> withPreActionEvents(PreActionEvent ... preActionEvents) {
        this.preActionEventSpecifier = bc -> Objects.nonNull(preActionEvents) ? Arrays.asList(preActionEvents) : null;
        return this;
    }

    public ActionDescriptionBuilder<T> validator(DataValidator<T> dataValidator) {
        this.dataValidator = dataValidator;
        return this;
    }

    ActionDescriptionBuilder<T> withBuilder(ActionsBuilder<T> actionsBuilder) {
        this.actionsBuilder = actionsBuilder;
        return this;
    }

    public ActionDescriptionBuilder<T> updateRequired(Boolean updateRequired) {
        this.updateRequired = updateRequired;
        return this;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionsBuilder<T> add(Boolean updateRequired) {
        ActionDescription<T> actionDescription = this.build(updateRequired);
        this.actionsBuilder.addAction(actionDescription);
        return this.actionsBuilder;
    }

    @Deprecated(since="4.0.0-M7")
    public ActionsBuilder<T> add() {
        return this.add(null);
    }

    public ActionDescription<T> build(Boolean updateRequired) {
        ActionInvoker<T> invoker = this.actionInvoker == null ? ActionInvoker.UNSUPPORTED_OPERATION : (updateRequired == null ? this.actionInvoker : (updateRequired != false ? ActionDescriptionBuilder.withUpdate(this.actionInvoker) : ActionDescriptionBuilder.withoutUpdate(this.actionInvoker)));
        return new ActionDescription<T>(this.key, this.text, this.customParameter, ActionAvailableChecker.and((ActionAvailableChecker)ObjectUtils.defaultIfNull((Object)this.baseActionAvailableChecker, (Object)ActionAvailableChecker.ALWAYS_TRUE), (ActionAvailableChecker)ObjectUtils.defaultIfNull((Object)this.actionAvailableChecker, (Object)ActionAvailableChecker.ALWAYS_TRUE)), invoker, (PreActionSpecifier)ObjectUtils.defaultIfNull((Object)this.preActionSpecifier, (Object)PreActionSpecifierType.WITHOUT_PREACTION), (PreActionEventSpecifier)ObjectUtils.defaultIfNull((Object)this.preActionEventSpecifier, bc -> null), (DataValidator)ObjectUtils.defaultIfNull(this.dataValidator, (bc, data, entityDto) -> Collections.emptyList()), this.iconCode.getActionIconCode(), this.showOnlyIcon, this.actionScope, this.autoSaveBefore);
    }

    public ActionDescription<T> build() {
        return this.build(this.updateRequired);
    }

    @Generated
    public ActionDescriptionBuilder() {
    }
}

