/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.action;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.ActionDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.dto.rowmeta.ActionsDTO;
import org.cxbox.core.service.action.ActionDescription;
import org.cxbox.core.service.action.ActionGroupDescription;
import org.cxbox.core.service.action.ActionsBuilder;

public class Actions<T extends DataResponseDTO> {
    final List<ActionDescription<T>> actionDefinitions;
    final List<ActionGroupDescription<T>> actionGroupDefinitions;

    public static <T extends DataResponseDTO> ActionsBuilder<T> builder() {
        return new ActionsBuilder();
    }

    public ActionDescription<T> getAction(String key) {
        ArrayList allActions = new ArrayList(this.actionDefinitions);
        this.actionGroupDefinitions.forEach(group -> allActions.addAll(group.getActions()));
        return allActions.stream().filter(actionDescription -> Objects.equals(key, actionDescription.getKey())).findFirst().orElse(null);
    }

    public ActionsDTO toDto(BusinessComponent bc) {
        ActionsDTO result = new ActionsDTO();
        this.actionDefinitions.forEach(actionDescription -> result.addMethod((ActionDescription)actionDescription, bc));
        for (ActionGroupDescription<T> group : this.actionGroupDefinitions) {
            ArrayList<ActionDTO> groupActionDtos = new ArrayList<ActionDTO>();
            List<ActionDescription<ActionDescription>> groupActions = group.getActions();
            groupActions.forEach(actionDescription -> groupActionDtos.add(actionDescription.toDto(bc)));
            result.addGroup(group.getKey(), group.getText(), group.getMaxGroupVisualButtonsCount(), groupActionDtos, group.getIconCode(), group.isShowOnlyIcon());
        }
        return result;
    }

    @ConstructorProperties(value={"actionDefinitions", "actionGroupDefinitions"})
    @Generated
    public Actions(List<ActionDescription<T>> actionDefinitions, List<ActionGroupDescription<T>> actionGroupDefinitions) {
        this.actionDefinitions = actionDefinitions;
        this.actionGroupDefinitions = actionGroupDefinitions;
    }

    @Generated
    public List<ActionDescription<T>> getActionDefinitions() {
        return this.actionDefinitions;
    }

    @Generated
    public List<ActionGroupDescription<T>> getActionGroupDefinitions() {
        return this.actionGroupDefinitions;
    }
}

