/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.filter.provider.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.core.util.filter.provider.impl.AbstractClassifyDataProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DictionaryValueProvider
extends AbstractClassifyDataProvider
implements ClassifyDataProvider {
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    @Override
    protected List<ClassifyDataParameter> getProviderParameterValues(Field dtoField, ClassifyDataParameter dataParameter, FilterParameter filterParam, SearchParameter searchParam, List<ClassifyDataProvider> providers) {
        Class<?> type = this.getDictType(dtoField);
        if (SearchOperation.CONTAINS_ONE_OF.equals((Object)dataParameter.getOperator()) || SearchOperation.EQUALS_ONE_OF.equals((Object)dataParameter.getOperator())) {
            dataParameter.setValue(filterParam.getStringValuesAsList().stream().map(val -> this.convertDictToTargetType(this.objectMapper.convertValue(val, type))).collect(Collectors.toList()));
        } else {
            dataParameter.setValue(this.convertDictToTargetType(this.objectMapper.convertValue((Object)filterParam.getStringValue(), type)));
        }
        List<ClassifyDataParameter> result = Collections.singletonList(dataParameter);
        return result;
    }

    public Object convertDictToTargetType(Object value) {
        return value;
    }

    private Class<?> getDictType(Field dtoField) {
        Class<?> dtoFieldType;
        Class<?> type = dtoFieldType = dtoField.getType();
        return type;
    }

    @ConstructorProperties(value={"objectMapper"})
    @Generated
    public DictionaryValueProvider(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictionaryValueProvider)) {
            return false;
        }
        DictionaryValueProvider other = (DictionaryValueProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DictionaryValueProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }
}

