/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util;

import java.sql.Date;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.exception.ServerException;
import org.cxbox.api.util.tz.TimeZoneUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtil.class);
    public static final Pattern ISO_PATTERN = Pattern.compile("^(?<year>-?(?:[1-9][0-9]*)?[0-9]{4})-(?<month>1[0-2]|0[1-9])-(?<day>3[01]|0[1-9]|[12][0-9])T(?<hour>2[0-3]|[01][0-9]):(?<minute>[0-5][0-9]):(?<second>[0-5][0-9])(?<ms>\\.[0-9]+)?(?<timezone>Z|[+-](?:2[0-3]|[01][0-9]):[0-5][0-9])?$");
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");

    public static String dateTimeToString(LocalDateTime dateTime, String pattern) {
        try {
            return dateTime.format(DateTimeFormatter.ofPattern(pattern));
        }
        catch (DateTimeException e) {
            log.warn(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0434\u0430\u0442\u044b %s. \u0424\u043e\u0440\u043c\u0430\u0442: %s", dateTime, pattern), (Throwable)e);
            throw new ServerException(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0434\u0430\u0442\u044b %s. \u0424\u043e\u0440\u043c\u0430\u0442: %s", dateTime, pattern));
        }
    }

    public static String dateTimeToString(LocalDateTime dateTime) {
        return DateTimeUtil.dateTimeToString(dateTime, TIMESTAMP_FORMAT);
    }

    public static LocalDateTime stringToDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        Matcher matcher = ISO_PATTERN.matcher(dateTime);
        if (!matcher.matches()) {
            log.warn(String.format("\u0414\u0430\u0442\u0430 %s \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 %s", dateTime, ISO_PATTERN.pattern()));
            throw new ServerException(String.format("\u0414\u0430\u0442\u0430 %s \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 %s", dateTime, ISO_PATTERN.pattern()));
        }
        if (matcher.group("timezone") == null) {
            return LocalDateTime.parse(dateTime);
        }
        return DateTimeUtil.toLocalDateTime(OffsetDateTime.parse(dateTime).toInstant());
    }

    public static java.util.Date toDate(LocalDateTime localDateTime) {
        return java.util.Date.from(DateTimeUtil.toInstant(localDateTime));
    }

    public static LocalDateTime toLocalDateTime(java.util.Date date) {
        return DateTimeUtil.toLocalDateTime(date.toInstant());
    }

    public static LocalDateTime toLocalDateTime(Calendar cal) {
        return DateTimeUtil.toLocalDateTime(cal.toInstant());
    }

    public static LocalDateTime toLocalDateTime(XMLGregorianCalendar calendar) {
        return DateTimeUtil.toLocalDateTime(calendar.toGregorianCalendar());
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(OffsetDateTime offsetDateTime) {
        return DateTimeUtil.toLocalDateTime(offsetDateTime.toInstant());
    }

    public static LocalDateTime toLocalDateTime(ZonedDateTime zonedDateTime) {
        return DateTimeUtil.toLocalDateTime(zonedDateTime.toInstant());
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toLocalDate().atStartOfDay();
    }

    public static Instant toInstant(LocalDateTime localDateTime, ZoneId zoneId) {
        return DateTimeUtil.toZonedDateTime(localDateTime, zoneId).toInstant();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return DateTimeUtil.toInstant(localDateTime, ZoneId.systemDefault());
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId);
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime sessionNow() {
        return DateTimeUtil.now().with(DateTimeUtil.toSession());
    }

    public static TemporalAdjuster toSession() {
        return DateTimeUtil.toSession(true);
    }

    public static TemporalAdjuster toSession(boolean tzAware) {
        return temporal -> tzAware ? DateTimeUtil.toSession((LocalDateTime)temporal) : temporal;
    }

    public static LocalDateTime toSession(LocalDateTime localDateTime) {
        return DateTimeUtil.switchZone(localDateTime, ZoneId.systemDefault(), TimeZoneUtil.getSessionZoneId());
    }

    public static LocalDateTime fromSession(LocalDateTime localDateTime) {
        return DateTimeUtil.switchZone(localDateTime, TimeZoneUtil.getSessionZoneId(), ZoneId.systemDefault());
    }

    public static TemporalAdjuster fromSession() {
        return DateTimeUtil.fromSession(true);
    }

    public static TemporalAdjuster fromSession(boolean tzAware) {
        return temporal -> tzAware ? DateTimeUtil.fromSession((LocalDateTime)temporal) : temporal;
    }

    public static TemporalAdjuster asEndOfDay() {
        return temporal -> ((LocalDateTime)temporal).withHour(23).withMinute(59).withSecond(59).withNano(999999999);
    }

    public static TemporalAdjuster asStartOfDay() {
        return temporal -> ((LocalDateTime)temporal).withHour(0).withMinute(0).withSecond(0).withNano(0);
    }

    public static LocalDateTime switchZone(LocalDateTime localDateTime, ZoneId from, ZoneId to) {
        return LocalDateTime.ofInstant(DateTimeUtil.toInstant(localDateTime, from), to);
    }

    public static String toOracleSql(LocalDateTime localDateTime) {
        String stringValue = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS"));
        return "TO_TIMESTAMP('" + stringValue + "', 'YYYY-MM-DD HH24:MI:SS.FF9')";
    }

    public static int getNumberMonthByName(String key) {
        TemporalAccessor accessorMonth = DateTimeFormatter.ofPattern("MMM").withLocale(Locale.ENGLISH).parse(key.substring(0, 3));
        return accessorMonth.get(ChronoField.MONTH_OF_YEAR);
    }

    public static TemporalAdjuster asStartOfQ1() {
        return temporal -> ((LocalDateTime)temporal).withMonth(1).withDayOfMonth(1).with(DateTimeUtil.asStartOfDay());
    }

    public static TemporalAdjuster asEndOfQ1() {
        return temporal -> ((LocalDateTime)temporal).withMonth(3).withDayOfMonth(31).with(DateTimeUtil.asEndOfDay());
    }

    public static TemporalAdjuster asStartOfQ2() {
        return temporal -> ((LocalDateTime)temporal).withMonth(4).withDayOfMonth(1).with(DateTimeUtil.asStartOfDay());
    }

    public static TemporalAdjuster asEndOfQ2() {
        return temporal -> ((LocalDateTime)temporal).withMonth(6).withDayOfMonth(30).with(DateTimeUtil.asEndOfDay());
    }

    public static TemporalAdjuster asStartOfQ3() {
        return temporal -> ((LocalDateTime)temporal).withMonth(7).withDayOfMonth(1).with(DateTimeUtil.asStartOfDay());
    }

    public static TemporalAdjuster asEndOfQ3() {
        return temporal -> ((LocalDateTime)temporal).withMonth(9).withDayOfMonth(30).with(DateTimeUtil.asEndOfDay());
    }

    public static TemporalAdjuster asStartOfQ4() {
        return temporal -> ((LocalDateTime)temporal).withMonth(10).withDayOfMonth(1).with(DateTimeUtil.asStartOfDay());
    }

    public static TemporalAdjuster asEndOfQ4() {
        return temporal -> ((LocalDateTime)temporal).withMonth(12).withDayOfMonth(31).with(DateTimeUtil.asEndOfDay());
    }

    public static TemporalAdjuster asStartOfFirstHalfYear() {
        return temporal -> temporal.with(DateTimeUtil.asStartOfQ1());
    }

    public static TemporalAdjuster asEndOfFirstHalfYear() {
        return temporal -> temporal.with(DateTimeUtil.asEndOfQ2());
    }

    public static TemporalAdjuster asStartOfSecondHalfYear() {
        return temporal -> temporal.with(DateTimeUtil.asStartOfQ3());
    }

    public static TemporalAdjuster asEndOfSecondHalfYear() {
        return temporal -> temporal.with(DateTimeUtil.asEndOfQ4());
    }

    public static boolean isMonthYearAfterDate(String month, String year, LocalDateTime createdDateTime) {
        LocalDateTime checkDay;
        LocalDateTime constructedDateTime = checkDay = createdDateTime.with(DateTimeUtil.asStartOfDay());
        if (StringUtils.isNotBlank((CharSequence)year)) {
            constructedDateTime = constructedDateTime.withYear(Integer.parseInt(year));
        }
        if (StringUtils.isNotBlank((CharSequence)month)) {
            constructedDateTime = constructedDateTime.withMonth(DateTimeUtil.getNumberMonthByName(month));
        }
        return constructedDateTime.isAfter(checkDay);
    }

    public static boolean isSameDay(LocalDateTime dateTime1, LocalDateTime dateTime2) {
        if (dateTime1 == null || dateTime2 == null) {
            return false;
        }
        return dateTime1.toLocalDate().isEqual(dateTime2.toLocalDate());
    }

    @Generated
    private DateTimeUtil() {
    }
}

