/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dao.impl;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.FetchParent;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.ManagedType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.util.CxReflectionUtils;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.FilterParameters;
import org.cxbox.core.controller.param.SortParameter;
import org.cxbox.core.controller.param.SortParameters;
import org.cxbox.core.controller.param.SortType;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.dto.LovUtils;
import org.cxbox.core.util.SpringBeanUtils;
import org.cxbox.core.util.filter.MultisourceSearchParameter;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.core.util.filter.provider.impl.BooleanValueProvider;
import org.cxbox.core.util.filter.provider.impl.MultisourceValueProvider;
import org.cxbox.model.core.dao.impl.DialectName;
import org.cxbox.model.core.entity.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataUtils.class);

    public static List<ClassifyDataParameter> mapSearchParamsToPOJO(Class dtoClazz, FilterParameters filterParameters, List<ClassifyDataProvider> providers) {
        ArrayList<ClassifyDataParameter> result = new ArrayList<ClassifyDataParameter>();
        filterParameters.forEach(filterParam -> {
            try {
                Field dtoField = Optional.ofNullable(CxReflectionUtils.findField((Class)dtoClazz, (String)filterParam.getName())).orElseThrow(() -> new IllegalArgumentException(ErrorMessageSource.errorMessage((String)"error.class_field_not_found", (Object[])new Object[]{filterParam.getName(), dtoClazz.getName()})));
                MultisourceSearchParameter multisourceParameter = dtoField.getDeclaredAnnotation(MultisourceSearchParameter.class);
                if (multisourceParameter != null) {
                    providers.stream().filter(p -> p.getClass().equals(multisourceParameter.provider())).findFirst().ifPresent(dataProvider -> result.addAll(dataProvider.getClassifyDataParameters(dtoField, (FilterParameter)filterParam, null, providers)));
                } else {
                    SearchParameter searchParam = Optional.ofNullable(dtoField.getDeclaredAnnotation(SearchParameter.class)).orElseThrow(() -> new IllegalArgumentException(ErrorMessageSource.errorMessage((String)"error.missing_search_parameter_annotation", (Object[])new Object[]{filterParam.getName()})));
                    providers.stream().filter(p -> p.getClass().equals(searchParam.provider())).findFirst().ifPresent(dataProvider -> result.addAll(dataProvider.getClassifyDataParameters(dtoField, (FilterParameter)filterParam, searchParam, providers)));
                }
            }
            catch (Exception e) {
                log.warn(ErrorMessageSource.errorMessage((String)"error.failed_to_parse_filter_param", (Object[])new Object[]{filterParam}), (Throwable)e);
            }
        });
        return result;
    }

    public static boolean mayBeNull(Root<?> root, Path path) {
        Bindable model = path.getModel();
        Bindable.BindableType type = model.getBindableType();
        if (type != Bindable.BindableType.SINGULAR_ATTRIBUTE) {
            return true;
        }
        if (path.getParentPath() != root) {
            return true;
        }
        return !model.getBindableJavaType().isPrimitive();
    }

    public static Comparable requireComparable(Object value) {
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        throw new IllegalArgumentException();
    }

    public static String requireString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException();
    }

    public static JoinType getJoinType(From from, String attrName) {
        ManagedType managedType;
        JoinType joinType = JoinType.INNER;
        Bindable model = from.getModel();
        if (model.getBindableType() == Bindable.BindableType.ENTITY_TYPE && (managedType = (ManagedType)model).getAttribute(attrName).isAssociation()) {
            joinType = JoinType.LEFT;
        }
        return joinType;
    }

    public static JoinType getJoinType(FetchParent fetch, String attrName) {
        if (fetch instanceof From) {
            return MetadataUtils.getJoinType((From)fetch, attrName);
        }
        return JoinType.LEFT;
    }

    public static Join joinEntity(From from, String attrName) {
        Set joins = from.getJoins();
        for (Join join : joins) {
            if (!join.getAttribute().getName().equals(attrName)) continue;
            return join;
        }
        return from.join(attrName, MetadataUtils.getJoinType(from, attrName));
    }

    public static Path getFieldPath(String fieldName, Root<?> root) {
        if (fieldName.contains(".")) {
            String[] fieldArr = fieldName.split("\\.");
            Join partialFrom = root;
            for (int i = 0; i < fieldArr.length - 1; ++i) {
                partialFrom = MetadataUtils.joinEntity(partialFrom, fieldArr[i]);
            }
            return partialFrom.get(fieldArr[fieldArr.length - 1]);
        }
        if (MetadataUtils.isElementCollectionField(root, fieldName)) {
            return root.join(fieldName);
        }
        return root.get(fieldName);
    }

    public static Predicate createPredicate(Root<?> root, ClassifyDataParameter criteria, CriteriaBuilder cb, DialectName dialect) {
        try {
            Predicate filterPredicate;
            Object value = criteria.getValue();
            Path field = MetadataUtils.getFieldPath(criteria.getField(), root);
            ClassifyDataProvider classifyDataProvider = MetadataUtils.getProviderFromParam(criteria.getProvider());
            Predicate predicate = filterPredicate = classifyDataProvider == null ? null : classifyDataProvider.getFilterPredicate(criteria.getOperator(), root, cb, criteria, field, value, dialect);
            if (filterPredicate != null) {
                return filterPredicate;
            }
            switch (criteria.getOperator()) {
                case EQUALS: {
                    if (value instanceof String) {
                        return cb.equal(cb.upper((Expression)field), (Object)MetadataUtils.requireString(value).toUpperCase());
                    }
                    return cb.equal((Expression)field, value);
                }
                case CONTAINS: {
                    return cb.like(cb.upper((Expression)field), "%" + MetadataUtils.requireString(value).toUpperCase() + "%");
                }
                case GREATER_THAN: {
                    return cb.greaterThan((Expression)field, MetadataUtils.requireComparable(value));
                }
                case LESS_THAN: {
                    return cb.lessThan((Expression)field, MetadataUtils.requireComparable(value));
                }
                case GREATER_OR_EQUAL_THAN: {
                    return cb.greaterThanOrEqualTo((Expression)field, MetadataUtils.requireComparable(value));
                }
                case LESS_OR_EQUAL_THAN: {
                    return cb.lessThanOrEqualTo((Expression)field, MetadataUtils.requireComparable(value));
                }
                case INTERVALS: {
                    return cb.or((Predicate[])((List)value).stream().map(object -> cb.and((Expression)cb.greaterThanOrEqualTo((Expression)field, MetadataUtils.requireComparable(object.getStart())), (Expression)cb.lessThanOrEqualTo((Expression)field, MetadataUtils.requireComparable(object.getEnd())))).toArray(Predicate[]::new));
                }
                case SPECIFIED: {
                    boolean isSpecified = BooleanUtils.isTrue((Boolean)((Boolean)value));
                    if (BooleanValueProvider.class.equals(criteria.getProvider())) {
                        return isSpecified ? cb.equal((Expression)field, (Object)true) : (MetadataUtils.mayBeNull(root, field) ? cb.or((Expression)cb.isNull((Expression)field), (Expression)cb.equal((Expression)field, (Object)false)) : cb.equal((Expression)field, (Object)false));
                    }
                    return isSpecified ? cb.isNotNull((Expression)field) : cb.isNull((Expression)field);
                }
                case EQUALS_ONE_OF: {
                    if (((List)value).stream().allMatch(s -> s instanceof String)) {
                        return cb.or((Predicate[])((List)value).stream().map(object -> cb.equal(cb.upper((Expression)field), (Object)MetadataUtils.requireString(object).toUpperCase())).toArray(Predicate[]::new));
                    }
                    return cb.or((Predicate[])((List)value).stream().map(object -> cb.equal((Expression)field, object)).toArray(Predicate[]::new));
                }
                case CONTAINS_ONE_OF: {
                    return cb.or((Predicate[])((List)value).stream().map(object -> cb.like(cb.upper((Expression)field), "%".concat(MetadataUtils.requireString(object).toUpperCase()).concat("%"))).toArray(Predicate[]::new));
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            log.warn("error when try to parse search expr: " + criteria.getField() + "." + criteria.getOperator() + "=" + criteria.getValue(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ClassifyDataProvider getProviderFromParam(@NonNull Class<? extends ClassifyDataProvider> provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (provider == null) {
            return null;
        }
        try {
            return SpringBeanUtils.getBean(provider);
        }
        catch (Exception e) {
            try {
                return provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                log.error("Error getting a provider instance. Exception message: " + e.getMessage());
                return null;
            }
        }
    }

    public static <T> void addSorting(Class dtoClazz, Root<?> root, CriteriaQuery<T> query, CriteriaBuilder builder, SortParameters sort, DialectName dialect) {
        ArrayList<Order> orderList = new ArrayList<Order>();
        if (!query.getOrderList().isEmpty()) {
            orderList.addAll(query.getOrderList());
        }
        List sortedParams = sort.getParameters().stream().sorted(Comparator.comparingInt(SortParameter::getPriority)).collect(Collectors.toList());
        for (SortParameter p : sortedParams) {
            try {
                Expression order;
                String field = MetadataUtils.getSortField(dtoClazz, p);
                Expression fieldPath = MetadataUtils.getFieldPath(field, root);
                IDictionaryType lovType = MetadataUtils.getLovType(dtoClazz, p);
                SearchParameter searchParameter = MetadataUtils.getSearchParameter(dtoClazz, p);
                if (lovType != null) {
                    Collection dictDTOS = DictionaryCache.dictionary().getAll(lovType);
                    CriteriaBuilder.Case selectCase = builder.selectCase();
                    dictDTOS.forEach(arg_0 -> MetadataUtils.lambda$addSorting$16(selectCase, builder, (Path)fieldPath, arg_0));
                    order = selectCase.otherwise((Object)"");
                } else {
                    ClassifyDataProvider provider = searchParameter == null ? null : MetadataUtils.getProviderFromParam(searchParameter.provider());
                    Expression expression = provider != null ? provider.getSortExpression(searchParameter, builder, query, root, dtoClazz, (Path)fieldPath, dialect) : fieldPath;
                    Expression expression2 = order = expression == null ? fieldPath : expression;
                }
                if (SortType.ASC.equals((Object)p.getType())) {
                    orderList.add(builder.asc(order));
                    continue;
                }
                if (!SortType.DESC.equals((Object)p.getType())) continue;
                orderList.add(builder.desc(order));
            }
            catch (Exception exception) {
                log.warn("Couldn't parse sorting parameter {}", (Object)Optional.ofNullable(dtoClazz).map(c -> "for class " + c.getName()).orElse(""), (Object)exception);
            }
        }
        if (BaseEntity.class.isAssignableFrom(root.getJavaType())) {
            orderList.add(builder.desc((Expression)root.get("id")));
        }
        query.orderBy(orderList);
    }

    private static String getSortField(Class dtoClazz, SortParameter parameter) {
        SearchParameter fieldParameter;
        String field = dtoClazz == null ? parameter.getName() : ((fieldParameter = MetadataUtils.getSearchParameter(dtoClazz, parameter)) != null && !"".equals(fieldParameter.name()) ? fieldParameter.name() : parameter.getName());
        return field;
    }

    private static SearchParameter getSearchParameter(@NonNull Class dtoClazz, SortParameter parameter) {
        if (dtoClazz == null) {
            throw new NullPointerException("dtoClazz is marked non-null but is null");
        }
        Field dtoField = CxReflectionUtils.findField((Class)dtoClazz, (String)parameter.getName());
        if (dtoField == null) {
            throw new IllegalArgumentException("Couldn't find field " + parameter.getName() + " in class " + dtoClazz.getName());
        }
        return dtoField.getDeclaredAnnotation(SearchParameter.class);
    }

    private static IDictionaryType getLovType(Class dtoClazz, SortParameter parameter) {
        if (dtoClazz != null) {
            Field dtoField = CxReflectionUtils.findField((Class)dtoClazz, (String)parameter.getName());
            if (dtoField == null) {
                throw new IllegalArgumentException("Couldn't find field " + parameter.getName() + " in class " + dtoClazz.getName());
            }
            return LovUtils.getType(dtoField);
        }
        return null;
    }

    public static <T> Predicate getPredicateFromSearchParams(Root<T> root, CriteriaQuery<?> cq, CriteriaBuilder cb, Class dtoClazz, FilterParameters searchParams, List<ClassifyDataProvider> providers, DialectName dialect) {
        Predicate filterPredicate;
        if (searchParams == null) {
            return cb.and(new Predicate[0]);
        }
        List<ClassifyDataParameter> criteriaStrings = MetadataUtils.mapSearchParamsToPOJO(dtoClazz, searchParams, providers);
        boolean joinRequired = criteriaStrings.stream().anyMatch(param -> param.getField().contains("."));
        if (joinRequired) {
            Subquery filterSubquery = cq.subquery(Long.class);
            Class rootClass = root.getModel().getJavaType();
            Root subRoot = filterSubquery.from(rootClass);
            Predicate searchParamsRestriction = MetadataUtils.getAllSpecifications(cb, subRoot, criteriaStrings, dialect);
            filterSubquery.select((Expression)subRoot.get("id")).where((Expression)searchParamsRestriction);
            filterPredicate = cb.in((Expression)root.get("id")).value((Expression)filterSubquery);
        } else {
            filterPredicate = MetadataUtils.getAllSpecifications(cb, root, criteriaStrings, dialect);
        }
        return filterPredicate;
    }

    public static Predicate getAllSpecifications(CriteriaBuilder cb, Root<?> root, List<ClassifyDataParameter> criteriaStrings, DialectName dialect) {
        return cb.and((Predicate[])criteriaStrings.stream().map(criteria -> MetadataUtils.getSingleSpecification(cb, root, criteria, dialect)).filter(Objects::nonNull).toArray(Predicate[]::new));
    }

    private static Predicate getSingleSpecification(CriteriaBuilder cb, Root<?> root, ClassifyDataParameter criteria, DialectName dialect) {
        if (MultisourceValueProvider.class.equals(criteria.getProvider())) {
            List criteriaValue = (List)criteria.getValue();
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (Object innerList : criteriaValue) {
                predicates.add(MetadataUtils.getAllSpecifications(cb, root, (List)innerList, dialect));
            }
            return cb.or((Predicate[])predicates.stream().filter(Objects::nonNull).toArray(Predicate[]::new));
        }
        return MetadataUtils.createPredicate(root, criteria, cb, dialect);
    }

    private static boolean isElementCollectionField(Root<?> root, String fieldName) {
        Class rootClass = root.getModel().getJavaType();
        Field field = CxReflectionUtils.findField((Class)rootClass, (String)fieldName);
        return Optional.ofNullable(field).map(fld -> fld.isAnnotationPresent(ElementCollection.class)).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't find field %s in entity %s", fieldName, rootClass.getName())));
    }

    @Generated
    private MetadataUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$addSorting$16(CriteriaBuilder.Case selectCase, CriteriaBuilder builder, Path fieldPath, SimpleDictionary dictDTO) {
        selectCase.when((Expression)builder.equal((Expression)fieldPath, (Object)new LOV(dictDTO.getKey())), (Object)dictDTO.getValue());
    }
}

