/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.filter.provider.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.dao.impl.MetadataUtils;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.core.util.filter.provider.impl.AbstractClassifyDataProvider;
import org.cxbox.model.core.dao.impl.DialectName;
import org.springframework.stereotype.Component;

@Component
public class TimeValueProvider
extends AbstractClassifyDataProvider
implements ClassifyDataProvider {
    @Override
    protected List<ClassifyDataParameter> getProviderParameterValues(Field dtoField, ClassifyDataParameter dataParameter, FilterParameter filterParam, SearchParameter searchParam, List<ClassifyDataProvider> providers) {
        ArrayList<ClassifyDataParameter> result = new ArrayList();
        if (SearchOperation.CONTAINS_ONE_OF.equals((Object)dataParameter.getOperator()) || SearchOperation.EQUALS_ONE_OF.equals((Object)dataParameter.getOperator())) {
            throw new ClientException(ErrorMessageSource.errorMessage((String)"error.unsupported_type_filtration", (Object[])new Object[]{LocalDateTime.class}));
        }
        dataParameter.setValue(filterParam.getTimeValue());
        result = Collections.singletonList(dataParameter);
        return result;
    }

    @Override
    public Expression<?> getSortExpression(@NonNull SearchParameter searchParameter, @NonNull CriteriaBuilder builder, @NonNull CriteriaQuery query, @NonNull Root<?> root, @NonNull Class dtoClazz, @NonNull Path fieldPath, @NonNull DialectName dialect) {
        if (searchParameter == null) {
            throw new NullPointerException("searchParameter is marked non-null but is null");
        }
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (dtoClazz == null) {
            throw new NullPointerException("dtoClazz is marked non-null but is null");
        }
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect is marked non-null but is null");
        }
        if (searchParameter.provider() != null && searchParameter.provider().equals(TimeValueProvider.class)) {
            if (dialect.equals((Object)DialectName.ORACLE)) {
                return builder.function("TO_CHAR", String.class, new Expression[]{fieldPath, builder.literal((Object)"HH24:MI:SS")});
            }
            return fieldPath.as(LocalTime.class);
        }
        return null;
    }

    @Override
    public Predicate getFilterPredicate(@NonNull SearchOperation operator, @NonNull Root<?> root, @NonNull CriteriaBuilder cb, @NonNull ClassifyDataParameter criteria, @NonNull Path field, @NonNull Object value, @NonNull DialectName dialect) {
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (cb == null) {
            throw new NullPointerException("cb is marked non-null but is null");
        }
        if (criteria == null) {
            throw new NullPointerException("criteria is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect is marked non-null but is null");
        }
        if (value instanceof LocalTime) {
            switch (operator) {
                case EQUALS: {
                    return cb.equal(TimeValueProvider.getExpressionByTimePart(field, cb, dialect), (Object)MetadataUtils.requireComparable(value));
                }
                case GREATER_OR_EQUAL_THAN: {
                    return cb.greaterThanOrEqualTo(TimeValueProvider.getExpressionByTimePart(field, cb, dialect), MetadataUtils.requireComparable(value));
                }
                case LESS_OR_EQUAL_THAN: {
                    return cb.lessThanOrEqualTo(TimeValueProvider.getExpressionByTimePart(field, cb, dialect), MetadataUtils.requireComparable(value));
                }
            }
            return null;
        }
        return null;
    }

    @NonNull
    private static Expression getExpressionByTimePart(@NonNull Path field, @NonNull CriteriaBuilder cb, @NonNull DialectName dialect) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (cb == null) {
            throw new NullPointerException("cb is marked non-null but is null");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect is marked non-null but is null");
        }
        if (dialect.equals((Object)DialectName.ORACLE)) {
            return cb.function("TO_CHAR", String.class, new Expression[]{field, cb.literal((Object)"HH24:MI:SS")});
        }
        return field.as(LocalTime.class);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeValueProvider)) {
            return false;
        }
        TimeValueProvider other = (TimeValueProvider)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeValueProvider;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

