/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.TimeZone;
import org.cxbox.api.service.LocaleService;
import org.cxbox.api.service.session.CoreSessionService;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

public class EnhancedLocaleResolver
extends CookieLocaleResolver {
    private final CoreSessionService coreSessionService;
    private final LocaleService localeService;

    public EnhancedLocaleResolver(CoreSessionService coreSessionService, LocaleService localeService) {
        this.coreSessionService = coreSessionService;
        this.localeService = localeService;
        this.setRejectInvalidCookies(false);
        this.setLanguageTagCompliant(false);
        this.setCookieName("locale");
    }

    public Locale parseLocaleValue(String localeValue) {
        Locale locale = super.parseLocaleValue(localeValue);
        if (locale == null || !this.localeService.isLanguageSupported(locale.getLanguage())) {
            return null;
        }
        return locale;
    }

    public Locale determineDefaultLocale(HttpServletRequest request) {
        Locale locale = this.coreSessionService.getLocale(super.determineDefaultLocale(request));
        if (this.localeService.isLanguageSupported(locale.getLanguage())) {
            return locale;
        }
        return this.localeService.getDefaultLocale();
    }

    public TimeZone determineDefaultTimeZone(HttpServletRequest request) {
        return this.coreSessionService.getTimeZone(super.determineDefaultTimeZone(request));
    }
}

