/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.config.cache;

import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheResolver;

public class CacheManagerBasedCacheResolver
implements CacheResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheManagerBasedCacheResolver.class);
    private final CacheManager cxboxCachesManager;

    @NotNull
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Set cacheNames = context.getOperation().getCacheNames();
        if (cacheNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(cacheNames.size());
        cacheNames.forEach(cacheName -> {
            Cache cache = this.cxboxCachesManager.getCache(cacheName);
            if (cache == null) {
                log.warn("Cannot find cache named '" + cacheName + "' for " + String.valueOf(context.getOperation()));
            } else {
                result.add(cache);
            }
        });
        return result;
    }

    @ConstructorProperties(value={"cxboxCachesManager"})
    @Generated
    public CacheManagerBasedCacheResolver(CacheManager cxboxCachesManager) {
        this.cxboxCachesManager = cxboxCachesManager;
    }
}

