/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param.resolvers;

import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.util.locale.LocaleSpecification;
import org.cxbox.core.controller.param.resolvers.AbstractParameterArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class LocaleParameterArgumentResolver
extends AbstractParameterArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return LocaleSpecification.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (!this.supportsParameter(parameter)) {
            return PageSpecification.DEFAULT;
        }
        return new LocaleSpecification(this.getLocale(webRequest));
    }

    private LOV getLocale(NativeWebRequest webRequest) {
        String locale = LocaleParameterArgumentResolver.getParameterValue(webRequest.getParameterMap().get("_locale"));
        if (StringUtils.isNotBlank((CharSequence)locale)) {
            return new LOV(locale);
        }
        return null;
    }
}

