/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.state.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.state.BcState;
import org.cxbox.core.crudma.state.BcStateAware;
import org.cxbox.core.util.session.WebHelper;
import org.springframework.stereotype.Component;

@Component
public class BcStateAwareImpl
implements BcStateAware {
    private static final String BC_STATE = "bcState";
    private static final String CLIENT_ID = "ClientId";
    private static final String NO_CLIENT = "NO_CLIENT";

    @Override
    public void clear(BusinessComponent bc) {
        ClientStorage storage = this.getStorage();
        Optional.ofNullable(this.getState(storage)).ifPresent(state -> state.remove(BcKey.of(bc)));
        this.flushStorage(storage);
    }

    @Override
    public void set(BusinessComponent bc, BcState bcState) {
        ClientStorage storage = this.getStorage();
        Optional.ofNullable(this.getState(storage)).ifPresent(state -> state.put(BcKey.of(bc), bcState));
        this.flushStorage(storage);
    }

    @Override
    public BcState getState(BusinessComponent bc) {
        ClientStorage storage = this.getStorage();
        return Optional.ofNullable(this.getState(storage)).map(m -> (BcState)m.get(BcKey.of(bc))).orElse(null);
    }

    @Override
    public boolean isPersisted(BusinessComponent bc) {
        ClientStorage storage = this.getStorage();
        return Optional.ofNullable(this.getState(storage)).map(m -> (BcState)m.get(BcKey.of(bc))).map(BcState::isPersisted).orElse(true);
    }

    private Map<BcKey, BcState> getState(ClientStorage storage) {
        HttpServletRequest request = WebHelper.getCurrentRequest().orElse(null);
        if (storage == null || request == null) {
            return null;
        }
        return storage.getClientState(this.getClientId(request));
    }

    private String getClientId(HttpServletRequest request) {
        String clientId = request.getHeader(CLIENT_ID);
        if (clientId == null) {
            clientId = NO_CLIENT;
        }
        return clientId;
    }

    private ClientStorage getStorage() {
        HttpSession session = this.getHttpSession();
        if (session == null) {
            return null;
        }
        ClientStorage state = (ClientStorage)session.getAttribute(BC_STATE);
        if (state == null) {
            state = new ClientStorage();
            session.setAttribute(BC_STATE, (Object)state);
        }
        return state;
    }

    private void flushStorage(ClientStorage storage) {
        HttpSession session = this.getHttpSession();
        if (session != null) {
            session.setAttribute(BC_STATE, (Object)storage);
        }
    }

    private HttpSession getHttpSession() {
        HttpServletRequest request = WebHelper.getCurrentRequest().orElse(null);
        if (request == null) {
            return null;
        }
        return request.getSession(false);
    }

    static class ClientStorage
    implements Serializable {
        ConcurrentHashMap<String, ConcurrentHashMap<BcKey, BcState>> storage = new ConcurrentHashMap();

        ClientStorage() {
        }

        private Map<BcKey, BcState> getClientState(String clientId) {
            return this.storage.computeIfAbsent(clientId, s -> new ConcurrentHashMap());
        }
    }

    private static class BcKey
    implements Serializable {
        private final String id;
        private final String name;

        private static BcKey of(BusinessComponent bc) {
            return new BcKey(bc.getId(), bc.getName());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BcKey)) {
                return false;
            }
            BcKey other = (BcKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id;
            String other$id = other.id;
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BcKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id;
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "name"})
        @Generated
        public BcKey(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

