/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.mapper;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.CxReflectionUtils;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.mapper.DtoConstructor;
import org.cxbox.core.dto.mapper.RequestValueCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnySourceDtoConstructorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnySourceDtoConstructorService.class);
    private final RequestValueCache requestCache;

    public AnySourceDtoConstructorService(RequestValueCache requestCache, @Autowired(required=false) List<DtoConstructor<?, ? extends DataResponseDTO>> dtoConstructors) {
        this.requestCache = requestCache;
    }

    public <E, D extends DataResponseDTO> D create(E entity, Class<D> dtoClass, Collection<DtoField<D, ?>> fields, Map<String, Object> attributes) {
        DataResponseDTO dto;
        Class<?> entityClass = entity.getClass();
        Constructor matchingAccessibleConstructor = CxReflectionUtils.getMatchingAccessibleConstructor(dtoClass, (Class[])new Class[]{entityClass});
        if (matchingAccessibleConstructor != null) {
            dto = (DataResponseDTO)ConstructorUtils.invokeConstructor(dtoClass, (Object[])new Object[]{entity});
        } else if (dtoClass.equals(entityClass)) {
            dto = (DataResponseDTO)ConstructorUtils.invokeConstructor(dtoClass, (Object[])new Object[0]);
            BeanUtils.copyProperties(entity, (Object)dto);
        } else {
            throw new IllegalStateException("Cannot find mapper from " + entityClass.getCanonicalName() + " to " + dtoClass.getCanonicalName() + " Please add mapper:  variant 1: add constructor public " + dtoClass.getName() + "(" + entityClass.getCanonicalName() + " entity) { this.id = entity.id; //TODO>>other attributes mapping }  to " + dtoClass.getCanonicalName() + " class");
        }
        dto.setSerializableFields(fields.stream().map(DtoField::getName).collect(Collectors.toSet()));
        return (D)dto;
    }
}

