/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.mapper;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.mapper.DtoConstructor;
import org.cxbox.core.dto.mapper.Mapping;
import org.cxbox.core.dto.mapper.RequestValueCache;
import org.cxbox.model.core.dao.util.JpaUtils;
import org.cxbox.model.core.entity.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DtoConstructorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DtoConstructorService.class);
    private final RequestValueCache requestCache;
    private final Map<Key, DtoConstructor<? extends BaseEntity, ? extends DataResponseDTO>> constructors;

    public DtoConstructorService(RequestValueCache requestCache, @Autowired(required=false) List<DtoConstructor<? extends BaseEntity, ? extends DataResponseDTO>> dtoConstructors) {
        this.requestCache = requestCache;
        this.constructors = Optional.ofNullable(dtoConstructors).map(Collection::stream).map(s -> s.collect(Collectors.toMap(Key::new, Function.identity()))).orElse(Collections.emptyMap());
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D create(E entity, Class<D> dtoClass, Collection<DtoField<D, ?>> fields, Map<String, Object> attributes) {
        DataResponseDTO dto;
        DtoConstructor<E, D> dtoConstructor = this.findConstructor(entity, dtoClass);
        if (dtoConstructor != null) {
            dto = (DataResponseDTO)ConstructorUtils.invokeConstructor(dtoClass, (Object[])new Object[0]);
            dto.setId(entity.getId().toString());
            Mapping mapping = new Mapping(this.requestCache, dtoConstructor.getValueSuppliers(), entity);
            attributes.forEach(mapping::addAttribute);
            for (DtoField<D, ?> field : fields) {
                Optional<?> value = mapping.get(field);
                if (value.isPresent()) {
                    FieldUtils.writeField((Object)dto, (String)field.getName(), value.get(), (boolean)true);
                }
                dto.addComputedField(field.getName());
            }
        } else {
            dto = (DataResponseDTO)ConstructorUtils.invokeConstructor(dtoClass, (Object[])new Object[]{entity});
        }
        dto.setSerializableFields(fields.stream().map(DtoField::getName).collect(Collectors.toSet()));
        return (D)dto;
    }

    private <E extends BaseEntity, D extends DataResponseDTO> DtoConstructor<E, D> findConstructor(E entity, Class<D> dtoClass) {
        Class entityClass = JpaUtils.unproxiedClass(entity);
        do {
            DtoConstructor<? extends BaseEntity, ? extends DataResponseDTO> dtoConstructor;
            if (!BaseEntity.class.isAssignableFrom(entityClass) || (dtoConstructor = this.constructors.get(new Key(entityClass, dtoClass))) == null) continue;
            return dtoConstructor;
        } while (!BaseEntity.class.equals(entityClass = entityClass.getSuperclass()) && !Object.class.equals(entityClass) && entityClass != null);
        return null;
    }

    private static class Key {
        private final Class<? extends BaseEntity> entityClass;
        private final Class<? extends DataResponseDTO> dtoClass;

        Key(DtoConstructor<? extends BaseEntity, ? extends DataResponseDTO> dtoConstructor) {
            this(dtoConstructor.getEntityClass(), dtoConstructor.getDtoClass());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<? extends BaseEntity> this$entityClass = this.entityClass;
            Class<? extends BaseEntity> other$entityClass = other.entityClass;
            if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
                return false;
            }
            Class<? extends DataResponseDTO> this$dtoClass = this.dtoClass;
            Class<? extends DataResponseDTO> other$dtoClass = other.dtoClass;
            return !(this$dtoClass == null ? other$dtoClass != null : !this$dtoClass.equals(other$dtoClass));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends BaseEntity> $entityClass = this.entityClass;
            result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
            Class<? extends DataResponseDTO> $dtoClass = this.dtoClass;
            result = result * 59 + ($dtoClass == null ? 43 : $dtoClass.hashCode());
            return result;
        }

        @ConstructorProperties(value={"entityClass", "dtoClass"})
        @Generated
        public Key(Class<? extends BaseEntity> entityClass, Class<? extends DataResponseDTO> dtoClass) {
            this.entityClass = entityClass;
            this.dtoClass = dtoClass;
        }
    }
}

