/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.rowmeta.RowDependentFieldsMeta;
import org.cxbox.dictionary.DictionaryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class FieldsCommonMeta<T extends DataResponseDTO>
extends RowDependentFieldsMeta<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldsCommonMeta.class);

    public FieldsCommonMeta(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, Optional<DictionaryProvider> dictionaryProvider) {
        super(objectMapper, dictionaryProvider);
    }

    @SafeVarargs
    public final void enableFilter(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setFilterable(Boolean.valueOf(true))));
    }

    public final void setConcreteFilterValues(DtoField<? super T, ?> field, Collection<SimpleDictionary> dictDtoList) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.clearFilterValues();
            fieldDTO.setFilterValues(dictDtoList);
        });
    }

    @Deprecated(since="4.0.0-M12", forRemoval=true)
    public final void addConcreteFilterValue(DtoField<? super T, ?> field, SimpleDictionary dictDTO) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.addFilterValue(dictDTO));
    }

    @SafeVarargs
    public final void setForceActive(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setForceActive(Boolean.valueOf(true))));
    }

    @SafeVarargs
    @Deprecated(since="4.0.0-M12", forRemoval=true)
    public final void setEphemeral(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setEphemeral(Boolean.valueOf(true))));
    }

    public final void setFileAccept(DtoField<? super T, ?> field, @NonNull List<String> accept) {
        if (accept == null) {
            throw new NullPointerException("accept is marked non-null but is null");
        }
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setFileAccept(null);
            fieldDTO.setFileAccept(String.join((CharSequence)",", accept));
        });
    }

    @SafeVarargs
    public final void enableSort(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setSortable(Boolean.valueOf(true))));
    }
}

