/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.api.data.dto.rowmeta.Icon;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.rowmeta.FieldsDictionaryDeprecatedMeta;
import org.cxbox.core.dto.rowmeta.FieldsMeta;
import org.cxbox.dictionary.Dictionary;
import org.cxbox.dictionary.DictionaryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class FieldsDictionaryMeta<T extends DataResponseDTO>
extends FieldsDictionaryDeprecatedMeta<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldsDictionaryMeta.class);
    private final Optional<DictionaryProvider> dictionaryProvider;

    public FieldsDictionaryMeta(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, Optional<DictionaryProvider> dictionaryProvider) {
        super(objectMapper, dictionaryProvider);
        this.dictionaryProvider = dictionaryProvider;
    }

    public final <V extends Dictionary> void setDictionaryFilterValues(DtoField<? super T, V> field) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            Collection variants = this.dictionaryProvider.map(e -> e.getAll(field.getValueClazz())).orElse(new ArrayList());
            this.setDictionaryFilterValues(field, variants);
        });
    }

    public final <V extends Dictionary> void setDictionaryFilterValues(@Nullable DtoField<? super T, V> field, @NonNull Collection<V> variants) {
        if (variants == null) {
            throw new NullPointerException("variants is marked non-null but is null");
        }
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(Dictionary.of((Class)field.getValueClazz(), (String)"").getDictionaryType());
            List<SimpleDictionary> dictDTOList = this.mapDictionary(variants);
            fieldDTO.clearValues();
            this.setConcreteFilterValues(field, dictDTOList);
        });
    }

    public final <V extends Dictionary> void setDictionaryIcons(@Nullable DtoField<? super T, V> field, @NonNull Map<V, Icon> valueIconMap) {
        if (valueIconMap == null) {
            throw new NullPointerException("valueIconMap is marked non-null but is null");
        }
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.clearValues();
            this.dictionaryProvider.ifPresent(p -> valueIconMap.forEach((variant, icon) -> {
                DictionaryProvider.DictionaryValue value = p.lookupValue(variant);
                fieldDTO.setIconWithValue(value != null ? value.getValue() : null, icon);
            }));
        });
    }

    public final <T extends DataResponseDTO, E extends Enum<?>> void setEnumFilterValues(@NonNull FieldsMeta<T> fieldsMeta, @Nullable DtoField<? super T, E> field, E ... values) {
        if (fieldsMeta == null) {
            throw new NullPointerException("fieldsMeta is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (field != null) {
            fieldsMeta.setConcreteFilterValues(field, Arrays.stream(values).map(en -> new SimpleDictionary(en.name(), this.serialize((Enum<?>)en))).collect(Collectors.toList()));
        }
    }

    public final <E extends Enum<?>> void setEnumIcons(@Nullable DtoField<? super T, E> field, @NonNull Map<E, Icon> valueIconMap) {
        if (valueIconMap == null) {
            throw new NullPointerException("valueIconMap is marked non-null but is null");
        }
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.clearAllValues();
            valueIconMap.forEach((key, value) -> fieldDTO.setIconWithValue(this.serialize((Enum<?>)key), value));
        });
    }
}

