/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.core.dto.rowmeta.PreActionConfirmBuilder;
import org.cxbox.core.dto.rowmeta.PreActionConfirmWithWidgetBuilder;
import org.cxbox.core.dto.rowmeta.PreActionType;
import org.cxbox.meta.ui.field.WidgetName;
import org.cxbox.meta.ui.field.WidgetTypeFamily;

public class PreAction {
    public static final String WITHOUT_MESSAGE = "";
    private final PreActionType preActionType;
    private final String message;
    private final Map<String, String> customParameters;

    public PreAction(PreActionType preActionType, String message, Map<String, String> customParameters) {
        this.preActionType = preActionType;
        this.message = message;
        this.customParameters = customParameters;
    }

    private static PreAction preAction(PreActionType preAction, String message, Map<String, String> customParameters) {
        return PreAction.builder().preActionType(preAction).message(message).customParameters(customParameters).build();
    }

    public static PreAction confirm() {
        return PreAction.confirm(cf -> cf);
    }

    @Deprecated(since="4.0.0-M16", forRemoval=true)
    public static PreAction confirm(String text) {
        return PreAction.confirm(cf -> cf.text(text));
    }

    public static PreAction confirm(@NonNull UnaryOperator<PreActionConfirmBuilder.Cf> cf) {
        if (cf == null) {
            throw new NullPointerException("cf is marked non-null but is null");
        }
        return PreActionConfirmBuilder.Cf.confirmBuilder(cf);
    }

    public static PreAction confirmWithWidget(@WidgetName(typeFamily={WidgetTypeFamily.FORM_POPUP}) @NonNull String widget, @NonNull UnaryOperator<PreActionConfirmWithWidgetBuilder.Cfw> cf) {
        if (widget == null) {
            throw new NullPointerException("widget is marked non-null but is null");
        }
        if (cf == null) {
            throw new NullPointerException("cf is marked non-null but is null");
        }
        return PreActionConfirmWithWidgetBuilder.Cfw.confirmWithWidgetBuilder(widget, cf);
    }

    public static PreAction info(String message) {
        return PreAction.preAction(PreActionType.INFORMATION, message, null);
    }

    public static PreAction info() {
        return PreAction.info(null);
    }

    public static PreAction error(String message) {
        return PreAction.preAction(PreActionType.ERROR, message, null);
    }

    public static PreAction error() {
        return PreAction.error(null);
    }

    public static PreAction custom(String message, Map<String, String> customParameters) {
        return PreAction.preAction(PreActionType.CUSTOM, message, customParameters);
    }

    public static PreActionBuilder builder() {
        return new PreActionBuilder();
    }

    public String getType() {
        return this.preActionType.getType();
    }

    public String getMessage() {
        return this.message;
    }

    @JsonAnyGetter
    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public String getMessage(String action) {
        if (WITHOUT_MESSAGE.equals(this.message)) {
            return this.message;
        }
        return StringUtils.isBlank((CharSequence)this.message) && Objects.nonNull((Object)this.preActionType) ? this.preActionType.getMessage(StringUtils.trimToEmpty((String)action)) : this.message;
    }

    public static class PreActionBuilder {
        private PreActionType preActionType;
        private String message;
        private Map<String, String> customParameters;

        PreActionBuilder() {
        }

        public PreActionBuilder preActionType(PreActionType preActionType) {
            this.preActionType = preActionType;
            return this;
        }

        public PreActionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public PreActionBuilder customParameters(Map<String, String> customParameters) {
            this.customParameters = customParameters;
            return this;
        }

        public PreAction build() {
            return new PreAction(this.preActionType, this.message, this.customParameters);
        }

        public String toString() {
            return "PreAction.PreActionBuilder(preActionType=" + String.valueOf((Object)this.preActionType) + ", message=" + this.message + ", customParameters=" + String.valueOf(this.customParameters) + ")";
        }
    }
}

