/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.external.core;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.controller.BCFactory;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.AnySourceBcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.crudma.state.BcState;
import org.cxbox.core.crudma.state.BcStateAware;
import org.cxbox.core.service.AnySourceResponseFactory;
import org.cxbox.core.service.AnySourceResponseService;
import org.cxbox.core.service.ResponseFactory;
import org.cxbox.core.service.ResponseService;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope
public class ParentDtoFirstLevelCache {
    private final ConcurrentHashMap<String, DataResponseDTO> cache = new ConcurrentHashMap();
    private final ResponseFactory respFactory;
    private final AnySourceResponseFactory anySourceResponseFactory;
    private final BCFactory bcFactory;
    private final TransactionService transactionService;
    private final BcStateAware bcStateAware;

    private <T extends DataResponseDTO> void putCacheValue(BusinessComponent parentBc, T value) {
        this.cache.put(parentBc.getName(), value);
    }

    public void restoreParentBc(boolean readOnly, BusinessComponent childBc) {
        BusinessComponent parentBc = this.getParentBcForRestore(childBc);
        if (parentBc != null) {
            if (parentBc.getDescription() instanceof AnySourceBcDescription) {
                this.restoreAnySourceParentBc(readOnly, parentBc);
            }
            if (parentBc.getDescription() instanceof InnerBcDescription) {
                this.restoreInnerBc(readOnly, parentBc);
            }
        }
    }

    public <P extends DataResponseDTO, F> F getParentField(DtoField<P, F> dtoField, BusinessComponent childBc) {
        P parentDto = this.getOneParentBcStateAware(childBc);
        return Optional.ofNullable(parentDto).map(dtoField.getGetter()).orElse(null);
    }

    private <P extends DataResponseDTO> P getOneParentBcStateAware(BusinessComponent childBc) {
        DataResponseDTO parentDto = this.cache.get(childBc.getParentName());
        if (parentDto == null) {
            parentDto = this.getOneParent(childBc).orElse(null);
        }
        return (P)parentDto;
    }

    private Optional<? extends DataResponseDTO> getOneParent(BusinessComponent childBc) {
        BusinessComponent parentBc = this.getParentBcForRestore(childBc);
        if (parentBc == null) {
            return Optional.empty();
        }
        if (parentBc.getDescription() instanceof AnySourceBcDescription) {
            return Optional.ofNullable(this.getAnySourceResponseService(parentBc).getOne(parentBc));
        }
        if (parentBc.getDescription() instanceof InnerBcDescription) {
            return Optional.ofNullable(this.getInnerBcResponseService(parentBc).getOne(parentBc));
        }
        return Optional.empty();
    }

    private void restoreAnySourceParentBc(boolean readOnly, BusinessComponent bc) {
        BcState state;
        if (bc != null && bc.getDescription() instanceof AnySourceBcDescription && (state = this.bcStateAware.getState(bc)) != null) {
            if (state.getPendingAction() != null) {
                QueryParameters originalParameters = bc.getParameters();
                originalParameters.setParameter("_action", state.getPendingAction());
                bc.setParameters(originalParameters);
            }
            AnySourceResponseService<?, ?> responseService = this.getAnySourceResponseService(bc);
            Object parentDto = null;
            if (readOnly) {
                if (!this.bcStateAware.isPersisted(bc)) {
                    parentDto = responseService.createEntity(bc).getRecord();
                }
                if (state.getDto() != null) {
                    parentDto = responseService.updateEntity(bc, state.getDto()).getRecord();
                }
            } else {
                parentDto = (DataResponseDTO)this.transactionService.invokeInNewRollbackOnlyTx(() -> {
                    DataResponseDTO result = null;
                    if (!this.bcStateAware.isPersisted(bc)) {
                        result = (DataResponseDTO)responseService.createEntity(bc).getRecord();
                    }
                    if (state.getDto() != null) {
                        result = (DataResponseDTO)responseService.updateEntity(bc, state.getDto()).getRecord();
                    }
                    return result;
                });
            }
            this.putCacheValue(bc, parentDto);
        }
    }

    private void restoreInnerBc(boolean readOnly, @Nullable BusinessComponent bc) {
        BcState state;
        if (bc != null && bc.getDescription() instanceof InnerBcDescription && (state = this.bcStateAware.getState(bc)) != null) {
            if (state.getPendingAction() != null) {
                QueryParameters originalParameters = bc.getParameters();
                originalParameters.setParameter("_action", state.getPendingAction());
                bc.setParameters(originalParameters);
            }
            ResponseService<?, ?> responseService = this.getInnerBcResponseService(bc);
            Object parentDto = null;
            if (readOnly) {
                if (!this.bcStateAware.isPersisted(bc)) {
                    parentDto = responseService.createEntity(bc).getRecord();
                }
                if (state.getDto() != null) {
                    parentDto = responseService.updateEntity(bc, state.getDto()).getRecord();
                }
            } else {
                parentDto = (DataResponseDTO)this.transactionService.invokeInNewRollbackOnlyTx(() -> {
                    DataResponseDTO result = null;
                    if (!this.bcStateAware.isPersisted(bc)) {
                        result = (DataResponseDTO)responseService.createEntity(bc).getRecord();
                    }
                    if (state.getDto() != null) {
                        result = (DataResponseDTO)responseService.updateEntity(bc, state.getDto()).getRecord();
                    }
                    return result;
                });
            }
            this.putCacheValue(bc, parentDto);
        }
    }

    @Nullable
    public BusinessComponent getParentBcForRestore(@NonNull BusinessComponent childBc) {
        if (childBc == null) {
            throw new NullPointerException("childBc is marked non-null but is null");
        }
        if (childBc.getHierarchy() == null || childBc.getHierarchy().getParent() == null) {
            return null;
        }
        return this.bcFactory.getBusinessComponent(childBc.getHierarchy().getParent(), QueryParameters.onlyDatesQueryParameters(childBc.getParameters()));
    }

    public AnySourceResponseService<?, ?> getAnySourceResponseService(BusinessComponent bc) {
        return this.anySourceResponseFactory.getService((AnySourceBcDescription)bc.getDescription());
    }

    public ResponseService<?, ?> getInnerBcResponseService(BusinessComponent bc) {
        return this.respFactory.getService((InnerBcDescription)bc.getDescription());
    }

    @ConstructorProperties(value={"respFactory", "anySourceResponseFactory", "bcFactory", "transactionService", "bcStateAware"})
    @Generated
    public ParentDtoFirstLevelCache(ResponseFactory respFactory, AnySourceResponseFactory anySourceResponseFactory, BCFactory bcFactory, TransactionService transactionService, BcStateAware bcStateAware) {
        this.respFactory = respFactory;
        this.anySourceResponseFactory = anySourceResponseFactory;
        this.bcFactory = bcFactory;
        this.transactionService = transactionService;
        this.bcStateAware = bcStateAware;
    }
}

