/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.file.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.cxbox.core.file.dto.CxboxResponseDTO;
import org.cxbox.core.file.dto.FileUploadDto;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

public interface CxboxFileController {
    public CxboxResponseDTO<? extends FileUploadDto> upload(@RequestParam(value="file") MultipartFile var1, @RequestParam(value="source", required=false) String var2);

    public HttpEntity<StreamingResponseBody> download(@RequestParam(value="id") String var1, @RequestParam(value="source", required=false) String var2, @RequestParam(value="preview", required=false, defaultValue="false") boolean var3);

    public CxboxResponseDTO<Void> remove(@RequestParam(value="id") String var1, @RequestParam(value="source") String var2);

    default public HttpEntity<StreamingResponseBody> buildFileHttpEntity(InputStream content, Long length, String fileName, String fileType, boolean preview) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Disposition", ContentDisposition.builder((String)(preview ? "inline" : "attachment")).filename(fileName, StandardCharsets.UTF_8).build().toString());
        headers.setContentType(this.getMediaType(fileType));
        headers.setContentLength(length.longValue());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(outputStream -> this.copy(content, outputStream, this.getChunkSize()));
    }

    default public int getChunkSize() {
        int mib = 0x100000;
        return mib * 5;
    }

    default public long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        return this.copyLarge(inputStream, outputStream, new byte[bufferSize]);
    }

    default public long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long count = 0L;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    default public MediaType getMediaType(String type) {
        try {
            return MediaType.parseMediaType((String)type);
        }
        catch (InvalidMediaTypeException e) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }
}

