/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.rowmeta;

import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.PlatformRequest;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.ExtremeBcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.dto.rowmeta.FieldsMeta;
import org.cxbox.core.dto.rowmeta.RowDependentFieldsMeta;
import org.cxbox.core.external.core.ParentDtoFirstLevelCache;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FieldMetaBuilder<T extends DataResponseDTO> {
    @Autowired
    private PlatformRequest platformRequest;
    @Autowired
    private ParentDtoFirstLevelCache parentDtoFirstLevelCache;

    public void buildRowDependentMeta(RowDependentFieldsMeta<T> fields, BusinessComponent bc) {
        if (bc.getDescription() instanceof InnerBcDescription) {
            this.buildRowDependentMeta(fields, (InnerBcDescription)bc.getDescription(), bc.getIdAsLong(), bc.getParentIdAsLong());
        } else if (bc.getDescription() instanceof ExtremeBcDescription) {
            this.buildExtremeRowDependentMeta(fields, (ExtremeBcDescription)bc.getDescription(), bc.getIdAsLong(), bc.getParentIdAsLong());
        }
    }

    public void buildIndependentMeta(FieldsMeta<T> fields, BusinessComponent bc) {
        this.buildIndependentMeta(fields, (InnerBcDescription)bc.getDescription(), bc.getParentIdAsLong());
    }

    public abstract void buildRowDependentMeta(RowDependentFieldsMeta<T> var1, InnerBcDescription var2, Long var3, Long var4);

    public void buildExtremeRowDependentMeta(RowDependentFieldsMeta<T> fields, ExtremeBcDescription bcDescription, Long id, Long parentId) {
    }

    public CrudmaActionType getActionType() {
        return this.platformRequest.getCrudmaActionType();
    }

    public BusinessComponent getBc() {
        return this.platformRequest.getBc();
    }

    public <P extends DataResponseDTO, F> F getParentField(DtoField<P, F> dtoField, BusinessComponent bc) {
        return this.parentDtoFirstLevelCache.getParentField(dtoField, bc);
    }

    public abstract void buildIndependentMeta(FieldsMeta<T> var1, InnerBcDescription var2, Long var3);
}

