/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.filter.provider.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.api.exception.ServerException;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.core.util.filter.provider.impl.AbstractClassifyDataProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EnumValueProvider
extends AbstractClassifyDataProvider
implements ClassifyDataProvider {
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    @Override
    protected List<ClassifyDataParameter> getProviderParameterValues(Field dtoField, ClassifyDataParameter dataParameter, FilterParameter filterParam, SearchParameter searchParam, List<ClassifyDataProvider> providers) {
        Class<?> type = this.getEnumType(dtoField);
        if (SearchOperation.CONTAINS_ONE_OF.equals((Object)dataParameter.getOperator()) || SearchOperation.EQUALS_ONE_OF.equals((Object)dataParameter.getOperator())) {
            dataParameter.setValue(filterParam.getStringValuesAsList().stream().map(val -> this.convertEnumToTargetType(this.objectMapper.convertValue(val, type))).collect(Collectors.toList()));
        } else {
            dataParameter.setValue(this.convertEnumToTargetType(this.objectMapper.convertValue((Object)filterParam.getStringValue(), type)));
        }
        List<ClassifyDataParameter> result = Collections.singletonList(dataParameter);
        return result;
    }

    public Object convertEnumToTargetType(Object value) {
        return value;
    }

    private Class<?> getEnumType(Field dtoField) {
        Class<?> dtoFieldType = dtoField.getType();
        Class<Object> type = Enum.class.isAssignableFrom(dtoFieldType) ? dtoFieldType : this.getType(dtoField).orElseThrow(() -> new ServerException("EnumValueProvider must be used with Enum dto field or field annotated with @BaseEnum"));
        return type;
    }

    private Optional<Class<? extends Enum<?>>> getType(Field field) {
        BaseEnum annotation = field.getAnnotation(BaseEnum.class);
        if (annotation != null) {
            return Optional.of(annotation.value());
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"objectMapper"})
    @Generated
    public EnumValueProvider(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumValueProvider)) {
            return false;
        }
        EnumValueProvider other = (EnumValueProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnumValueProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BaseEnum {
        public Class<? extends Enum<?>> value();
    }
}

