/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.filter.provider.impl;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.util.filter.MultisourceSearchParameter;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.springframework.stereotype.Component;

@Component
public class MultisourceValueProvider
implements ClassifyDataProvider {
    @Override
    public List<ClassifyDataParameter> getClassifyDataParameters(Field dtoField, FilterParameter filterParam, SearchParameter searchParam, List<ClassifyDataProvider> providers) {
        MultisourceSearchParameter multisourceParameter = dtoField.getDeclaredAnnotation(MultisourceSearchParameter.class);
        ClassifyDataParameter cdParameter = ClassifyDataParameter.builder().field(filterParam.getName()).operator(filterParam.getOperation()).provider(MultisourceValueProvider.class).value(Stream.of(multisourceParameter.value()).map(par -> {
            ClassifyDataProvider provider = providers.stream().filter(p -> p.getClass().equals(par.provider())).findFirst().orElseThrow(() -> new ClientException(ErrorMessageSource.errorMessage((String)"error.data_provider_not_found")));
            return provider.getClassifyDataParameters(dtoField, filterParam, (SearchParameter)par, providers);
        }).filter(par -> !par.isEmpty()).collect(Collectors.toList())).build();
        return Collections.singletonList(cdParameter);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultisourceValueProvider)) {
            return false;
        }
        MultisourceValueProvider other = (MultisourceValueProvider)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultisourceValueProvider;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

