/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import lombok.NonNull;
import org.cxbox.api.util.jackson.DtoPropertyFilter;
import org.cxbox.api.util.jackson.deser.contextual.TZAwareLDTContextualDeserializer;
import org.cxbox.api.util.jackson.ser.contextual.I18NAwareStringContextualSerializer;
import org.cxbox.api.util.jackson.ser.contextual.TZAwareJUDContextualSerializer;
import org.cxbox.api.util.jackson.ser.contextual.TZAwareLDTContextualSerializer;
import org.cxbox.core.config.properties.WidgetFieldsIdResolverProperties;
import org.cxbox.dictionary.Dictionary;
import org.cxbox.dictionary.DictionaryModule;
import org.cxbox.dictionary.DictionaryProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.SpringHandlerInstantiator;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableConfigurationProperties(value={WidgetFieldsIdResolverProperties.class})
public class JacksonConfig {
    @Bean(value={"cxboxObjectMapper"})
    public ObjectMapper cxboxObjectMapper(HandlerInstantiator handlerInstantiator, Optional<DictionaryProvider> dictionaryProvider) {
        return Jackson2ObjectMapperBuilder.json().handlerInstantiator(handlerInstantiator).modules(new Module[]{this.buildJavaTimeModule(), this.i18NModule(), DictionaryModule.buildDictionaryModule(dictionaryProvider, (boolean)true)}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, SerializationFeature.FLUSH_AFTER_WRITE_VALUE, JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM}).filters((FilterProvider)new SimpleFilterProvider().addFilter("dtoPropertyFilter", (SimpleBeanPropertyFilter)new DtoPropertyFilter())).build();
    }

    @Bean
    public HandlerInstantiator handlerInstantiator(ApplicationContext context) {
        return new SpringHandlerInstantiator(context.getAutowireCapableBeanFactory());
    }

    private JavaTimeModule buildJavaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new TZAwareLDTContextualDeserializer());
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new TZAwareLDTContextualSerializer());
        javaTimeModule.addSerializer(Date.class, (JsonSerializer)new TZAwareJUDContextualSerializer());
        return javaTimeModule;
    }

    private SimpleModule i18NModule() {
        SimpleModule i18NModule = new SimpleModule();
        i18NModule.addSerializer(String.class, (JsonSerializer)new I18NAwareStringContextualSerializer());
        return i18NModule;
    }

    @Bean
    public WebMvcConfigurer dictionaryWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addFormatters(@NonNull FormatterRegistry registry) {
                if (registry == null) {
                    throw new NullPointerException("registry is marked non-null but is null");
                }
                registry.addConverterFactory((ConverterFactory)new StringToDictionaryConverterFactory());
            }
        };
    }

    public static class StringToDictionaryConverterFactory
    implements ConverterFactory<String, Dictionary> {
        @NonNull
        public <T extends Dictionary> Converter<String, T> getConverter(@NonNull Class<T> targetType) {
            if (targetType == null) {
                throw new NullPointerException("targetType is marked non-null but is null");
            }
            if (!Dictionary.class.isAssignableFrom(targetType)) {
                throw new IllegalArgumentException("Target type " + targetType.getName() + " does not refer to dictionary");
            }
            return source -> source.isEmpty() ? null : Dictionary.of((Class)targetType, (String)source);
        }
    }
}

