/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.cxbox.core.controller.param.AbstractQueryParameter;
import org.cxbox.core.controller.param.ParameterBuilder;
import org.cxbox.core.controller.param.QueryParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.util.TypeConverter;

public class FilterParameter
extends AbstractQueryParameter {
    private final SearchOperation operation;
    private final String stringValue;

    public FilterParameter(String name, SearchOperation operation, String stringValue) {
        super(name);
        this.operation = operation;
        this.stringValue = stringValue;
    }

    @Override
    public <R> R apply(BiFunction<String, String, R> biFunction) {
        return biFunction.apply(String.format("%s.%s", this.getName(), this.operation.getOperationName()), this.stringValue);
    }

    public <T> T getValue(Class<T> clazz) {
        return TypeConverter.to(clazz, this.stringValue);
    }

    public Integer getIntegerValue() {
        return TypeConverter.toInteger(this.stringValue);
    }

    public Long getLongValue() {
        return TypeConverter.toLong(this.stringValue);
    }

    public Double getDoubleValue() {
        return TypeConverter.toDouble(this.stringValue);
    }

    public BigDecimal getBigDecimalValue() {
        return TypeConverter.toBigDecimal(this.stringValue);
    }

    public Boolean getBooleanValue() {
        return TypeConverter.toBoolean(this.stringValue);
    }

    public LocalDateTime getDateValue() {
        return TypeConverter.toLocalDateTime(this.stringValue);
    }

    public LocalTime getTimeValue() {
        return this.getDateValue() == null ? null : this.getDateValue().toLocalTime();
    }

    public List<String> getStringValuesAsList() {
        return QueryParameter.getListValue(this.stringValue, String.class);
    }

    public List<LocalDateTime> getDateValueAsList() {
        return QueryParameter.getListValue(this.stringValue, LocalDateTime.class);
    }

    public List<BigDecimal> getBigDecimalValuesAsList() {
        return QueryParameter.getListValue(this.stringValue, BigDecimal.class);
    }

    public List<Long> getLongValuesAsList() {
        return QueryParameter.getListValue(this.stringValue, Long.class);
    }

    @Generated
    public SearchOperation getOperation() {
        return this.operation;
    }

    @Generated
    public String getStringValue() {
        return this.stringValue;
    }

    @Generated
    public String toString() {
        return "FilterParameter(operation=" + this.getOperation() + ", stringValue=" + this.getStringValue() + ")";
    }

    public static class Builder
    implements ParameterBuilder<FilterParameter> {
        private static final ParameterBuilder<FilterParameter> INSTANCE = new Builder();

        public static ParameterBuilder<FilterParameter> getInstance() {
            return INSTANCE;
        }

        @Override
        public Class<FilterParameter> getParameterType() {
            return FilterParameter.class;
        }

        @Override
        public boolean matches(String key, String value) {
            if (!key.startsWith("_")) {
                String[] entryKey = key.split("\\.");
                return entryKey.length == 2;
            }
            return false;
        }

        @Override
        public FilterParameter buildParameter(String key, String value) {
            if (this.matches(key, value)) {
                String[] entryKey = key.split("\\.");
                return new FilterParameter(entryKey[0], SearchOperation.of(entryKey[1]), value);
            }
            return null;
        }
    }
}

