/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.DrillDownType;
import org.cxbox.core.dto.MessageType;
import org.cxbox.core.service.action.DrillDownTypeSpecifier;
import org.cxbox.core.service.drilldown.PlatformDrilldownService;
import org.cxbox.core.service.drilldown.filter.FC;
import org.cxbox.core.util.SpringBeanUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostAction {
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public static PostAction refreshBc(BcIdentifier bcIdentifier) {
        return new PostAction().add("type", "refreshBC").add("bc", bcIdentifier.getName());
    }

    public static PostAction refreshParentBc(BcIdentifier bcIdentifier) {
        return new PostAction().add("type", "refreshBC").add("bc", bcIdentifier.getParentName());
    }

    public static PostAction downloadFile(String fileId) {
        return new PostAction().add("type", "downloadFile").add("fileId", fileId);
    }

    public static PostAction downloadFileByUrl(String url) {
        return new PostAction().add("type", "downloadFileByUrl").add("url", url);
    }

    public static PostAction openPickList(String pickList) {
        return new PostAction().add("type", "openPickList").add("pickList", pickList);
    }

    public static PostAction drillDown(DrillDownTypeSpecifier drillDownType, String url) {
        return PostAction.drillDown(drillDownType, url, null);
    }

    public static PostAction drillDown(DrillDownTypeSpecifier drillDownType, String url, String urlName) {
        return new PostAction().add("type", "drillDown").add("url", url).add("urlName", urlName).add("drillDownType", drillDownType.getValue());
    }

    public static PostAction drillDownWithFilter(DrillDownTypeSpecifier drillDownType, String url, Consumer<FC> fc) {
        FC fcInstance = new FC();
        fc.accept(fcInstance);
        PlatformDrilldownService platformDrilldownService = SpringBeanUtils.getBean(PlatformDrilldownService.class);
        return new PostAction().add("type", "drillDown").add("url", url + Optional.ofNullable(platformDrilldownService.formUrlFilterPart(fcInstance)).map(fp -> "?" + fp).orElse("")).add("urlName", null).add("drillDownType", drillDownType.getValue());
    }

    public static PostAction delayedRefreshBC(BcIdentifier bcIdentifier, Number seconds) {
        return new PostAction().add("type", "delayedRefreshBC").add("bc", bcIdentifier.getName()).add("delay", seconds.toString());
    }

    public static PostAction showMessage(MessageType messageType, String messageText) {
        return new PostAction().add("type", "showMessage").add("messageType", messageType.getValue()).add("messageText", messageText);
    }

    public static PostAction postDelete() {
        return new PostAction().add("type", "postDelete");
    }

    public static <T extends DataResponseDTO, V> WaitUntilBuilder<T, V> waitUntil(@NonNull DtoField<? super T, V> successConditionField, @NonNull V successConditionValue) {
        if (successConditionField == null) {
            throw new NullPointerException("successConditionField is marked non-null but is null");
        }
        if (successConditionValue == null) {
            throw new NullPointerException("successConditionValue is marked non-null but is null");
        }
        return new WaitUntilBuilder<T, V>(successConditionField, successConditionValue);
    }

    public static <T extends DataResponseDTO, V> WaitUntilBuilder<T, V> drillDownAndWaitUntil(@NonNull String url, @NonNull BcIdentifier successConditionBc, @NonNull DtoField<? super T, V> successConditionField, @NonNull V successConditionValue) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (successConditionBc == null) {
            throw new NullPointerException("successConditionBc is marked non-null but is null");
        }
        if (successConditionField == null) {
            throw new NullPointerException("successConditionField is marked non-null but is null");
        }
        if (successConditionValue == null) {
            throw new NullPointerException("successConditionValue is marked non-null but is null");
        }
        return new WaitUntilBuilder<T, V>(DrillDownType.INNER, url, successConditionBc, successConditionField, successConditionValue);
    }

    @JsonAnyGetter
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonAnyGetter
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getURL() {
        return (String)this.attributes.get("url");
    }

    public String getType() {
        return (String)this.attributes.get("type");
    }

    public String getDrillDownType() {
        return (String)this.attributes.get("drillDownType");
    }

    public PostAction add(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public static class BasePostActionField {
        public static final String TYPE = "type";
        public static final String BC = "bc";
        public static final String FILE_ID = "fileId";
        public static final String DELAY = "delay";
        public static final String MESSAGE_TYPE = "messageType";
        public static final String MESSAGE_TEXT = "messageText";
        public static final String URL = "url";
        public static final String URL_NAME = "urlName";
        public static final String DRILL_DOWN_TYPE = "drillDownType";
        public static final String PICK_LIST = "pickList";
        public static final String SUCCESS_CONDITION_BC = "successCondition_bcName";
        public static final String SUCCESS_CONDITION_FIELD = "successCondition_fieldKey";
        public static final String SUCCESS_CONDITION_VALUE = "successCondition_value";
        public static final String SUCCESS_MESSAGE = "successMessage";
        public static final String IN_PROGRESS_MESSAGE = "inProgressMessage";
        public static final String TIMEOUT = "timeout";
        public static final String TIMEOUT_MAX_REQUESTS = "timeoutMaxRequests";
        public static final String TIMEOUT_MESSAGE = "timeoutMessage";

        private BasePostActionField() {
        }
    }

    public static class BasePostActionType {
        public static final String REFRESH_BC = "refreshBC";
        public static final String DOWNLOAD_FILE = "downloadFile";
        public static final String DOWNLOAD_FILE_BY_URL = "downloadFileByUrl";
        public static final String OPEN_PICK_LIST = "openPickList";
        public static final String DRILL_DOWN = "drillDown";
        public static final String DELAYED_REFRESH_BC = "delayedRefreshBC";
        public static final String SHOW_MESSAGE = "showMessage";
        public static final String POST_DELETE = "postDelete";
        public static final String WAIT_UNTIL = "waitUntil";
        public static final String DRILL_DOWN_AND_WAIT_UNTIL = "drillDownAndWaitUntil";

        private BasePostActionType() {
        }
    }

    public static class WaitUntilBuilder<T extends DataResponseDTO, V> {
        private final String type;
        private final DrillDownTypeSpecifier drillDownType;
        private final String url;
        private final String successConditionBc;
        private final DtoField<? super T, V> successConditionField;
        private final V successConditionValue;
        private String inProgressMessage;
        private String successMessage;
        private Duration timeout = Duration.ofSeconds(5L);
        private int timeoutMaxRequests = 3;
        private String timeoutMessage;

        private WaitUntilBuilder(@NonNull DrillDownTypeSpecifier drillDownType, @NonNull String url, @NonNull BcIdentifier successConditionBc, @NonNull DtoField<? super T, V> successConditionField, @NonNull V successConditionValue) {
            if (drillDownType == null) {
                throw new NullPointerException("drillDownType is marked non-null but is null");
            }
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            if (successConditionBc == null) {
                throw new NullPointerException("successConditionBc is marked non-null but is null");
            }
            if (successConditionField == null) {
                throw new NullPointerException("successConditionField is marked non-null but is null");
            }
            if (successConditionValue == null) {
                throw new NullPointerException("successConditionValue is marked non-null but is null");
            }
            this.type = "drillDownAndWaitUntil";
            this.drillDownType = drillDownType;
            this.url = url;
            this.successConditionBc = successConditionBc.getName();
            this.successConditionField = successConditionField;
            this.successConditionValue = successConditionValue;
        }

        private WaitUntilBuilder(@NonNull DtoField<? super T, V> successConditionField, @NonNull V successConditionValue) {
            if (successConditionField == null) {
                throw new NullPointerException("successConditionField is marked non-null but is null");
            }
            if (successConditionValue == null) {
                throw new NullPointerException("successConditionValue is marked non-null but is null");
            }
            this.type = "waitUntil";
            this.drillDownType = null;
            this.url = null;
            this.successConditionBc = null;
            this.successConditionField = successConditionField;
            this.successConditionValue = successConditionValue;
        }

        public WaitUntilBuilder<T, V> inProgressMessage(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.inProgressMessage = message;
            return this;
        }

        public WaitUntilBuilder<T, V> successMessage(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.successMessage = message;
            return this;
        }

        public WaitUntilBuilder<T, V> timeout(@NonNull Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            this.timeout = timeout;
            return this;
        }

        public WaitUntilBuilder<T, V> timeoutMaxRequests(int maxRequests) {
            this.timeoutMaxRequests = maxRequests;
            return this;
        }

        public WaitUntilBuilder<T, V> timeoutMessage(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.timeoutMessage = message;
            return this;
        }

        public PostAction build() {
            PostAction postAction = new PostAction().add("type", this.type).add("successCondition_bcName", this.successConditionBc).add("successCondition_fieldKey", this.successConditionField.getName()).add("successCondition_value", this.successConditionValue).add("inProgressMessage", this.inProgressMessage).add("successMessage", this.successMessage).add("timeout", String.valueOf(this.timeout.toMillis())).add("timeoutMaxRequests", String.valueOf(this.timeoutMaxRequests)).add("timeoutMessage", this.timeoutMessage);
            if (this.drillDownType != null) {
                postAction.add("drillDownType", this.drillDownType.getValue());
                postAction.add("url", this.url);
            }
            return postAction;
        }
    }
}

