/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.DataResponseDTO_;
import org.cxbox.api.data.dto.Entity;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.AnySourceBcDescription;
import org.cxbox.core.dto.BusinessError;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.AnySourceResponseService;
import org.cxbox.core.service.ChangedNowValidationService;
import org.cxbox.core.service.ResponseService;
import org.cxbox.core.service.ValidatorsProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class AnySourceResponseFactory {
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper mapper;
    private final ApplicationContext ctx;
    @Autowired
    private ValidatorsProvider validatorsProvider;
    @Autowired
    private ChangedNowValidationService changedNowValidationService;

    public AnySourceResponseService getService(AnySourceBcDescription anySourceBcDescription) {
        return (AnySourceResponseService)this.ctx.getBean(this.getServiceClass(anySourceBcDescription));
    }

    public DataResponseDTO getDTOFromMap(Map<String, Object> map, Class<?> clazz, BusinessComponent bc) {
        return this.getDTOFromMapDataAndChangedNow(map, clazz, bc, false);
    }

    public DataResponseDTO getDTOFromMapIgnoreBusinessErrors(Map<String, Object> map, Class<?> clazz, BusinessComponent bc) {
        return this.getDTOFromMapDataAndChangedNow(map, clazz, bc, true);
    }

    private DataResponseDTO getDTOFromMapDataAndChangedNow(Map<String, Object> map, Class<?> clazz, BusinessComponent bc, boolean ignoreBusinessErrors) {
        DataResponseDTO dataResponseDTO = this.getDTOFromMapInner(map, clazz, bc, ignoreBusinessErrors);
        HashMap changedNowMap = dataResponseDTO.getChangedNow_();
        if (changedNowMap != null) {
            DataResponseDTO changedNowDTO = this.getDTOFromMapInner(changedNowMap, clazz, bc, ignoreBusinessErrors);
            DataResponseDTO.ChangedNowParam changedNowParam = this.changedNowValidationService.buildCnangedNowParam(new HashSet<String>(changedNowMap.keySet()), changedNowDTO);
            dataResponseDTO.setChangedNowParam(changedNowParam);
        }
        return dataResponseDTO;
    }

    private DataResponseDTO getDTOFromMapInner(Map<String, Object> map, Class<?> clazz, BusinessComponent bc, boolean ignoreBusinessErrors) {
        Object objectResult;
        DtoDeserializationHandler handler = new DtoDeserializationHandler();
        this.mapper.addHandler((DeserializationProblemHandler)handler);
        try {
            objectResult = this.mapper.convertValue(map, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.dto_deserialization_error"));
        }
        if (!(objectResult instanceof DataResponseDTO)) {
            throw new IllegalArgumentException(clazz + " doesn't extend from " + DataResponseDTO.class);
        }
        BusinessError.Entity entity = null;
        Set violations = this.validatorsProvider.getValidator(clazz).validate(objectResult, new Class[0]);
        Set<String> badFields = handler.getFields();
        if (!badFields.isEmpty() || !violations.isEmpty()) {
            entity = new BusinessError.Entity(bc);
            for (String fieldName : badFields) {
                entity.addField(fieldName, ErrorMessageSource.errorMessage((String)"error.field_deserialization_error"));
            }
            if (!ignoreBusinessErrors) {
                for (ConstraintViolation violation : violations) {
                    String fieldName = null;
                    for (Path.Node node : violation.getPropertyPath()) {
                        fieldName = node.getName();
                    }
                    entity.addField(fieldName, violation.getMessage());
                }
                throw new BusinessException().setEntity(entity);
            }
        }
        HashSet<String> fields = new HashSet<String>(map.keySet());
        fields.remove(DataResponseDTO_.vstamp.getName());
        fields.remove(DataResponseDTO_.id.getName());
        DataResponseDTO result = (DataResponseDTO)objectResult;
        result.setChangedFields(fields);
        result.setId(bc.getId());
        if (entity != null && !entity.getFields().isEmpty()) {
            result.setErrors((Entity)entity);
        }
        return result;
    }

    public Class getDTOFromService(AnySourceBcDescription anySourceBcDescription) {
        return (Class)this.getResponseServiceParameters(anySourceBcDescription)[0];
    }

    private Type[] getResponseServiceParameters(Class<? extends AnySourceResponseService> cls) {
        Map typeArguments = TypeUtils.getTypeArguments(cls, AnySourceResponseService.class);
        return (Type[])Stream.of(AnySourceResponseService.class.getTypeParameters()).map(typeArguments::get).toArray(Type[]::new);
    }

    public Type[] getResponseServiceParameters(AnySourceBcDescription anySourceBcDescription) {
        return this.getResponseServiceParameters(this.getServiceClass(anySourceBcDescription));
    }

    private Class<? extends AnySourceResponseService> getServiceClass(AnySourceBcDescription anySourceBcDescription) {
        if (AnySourceResponseService.class.isAssignableFrom(anySourceBcDescription.getServiceClass())) {
            return anySourceBcDescription.getServiceClass();
        }
        throw new IllegalArgumentException("can't cast " + anySourceBcDescription.getServiceClass() + " to " + ResponseService.class);
    }

    @ConstructorProperties(value={"mapper", "ctx"})
    @Generated
    public AnySourceResponseFactory(@Qualifier(value="cxboxObjectMapper") ObjectMapper mapper, ApplicationContext ctx) {
        this.mapper = mapper;
        this.ctx = ctx;
    }

    class DtoDeserializationHandler
    extends DeserializationProblemHandler {
        private final Set<String> fields = new HashSet<String>();

        DtoDeserializationHandler() {
        }

        public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) {
            this.fields.add(ctxt.getParser().getParsingContext().getCurrentName());
            return null;
        }

        public Object handleWeirdNumberValue(DeserializationContext ctxt, Class<?> targetType, Number valueToConvert, String failureMsg) {
            this.fields.add(ctxt.getParser().getParsingContext().getCurrentName());
            return null;
        }

        public JavaType handleUnknownTypeId(DeserializationContext ctxt, JavaType baseType, String subTypeId, TypeIdResolver idResolver, String failureMsg) {
            this.fields.add(ctxt.getParser().getParsingContext().getCurrentName());
            return null;
        }

        public Set<String> getFields() {
            return this.fields;
        }
    }
}

